package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.Map;

@Slf4j
@Component
public class KonkeIotUtils {

	@Value("${konke.deviceCloud.baseUrl}")
	private String baseUrl;
	@Value("${konke.deviceCloud.appId}")
	private String appId;

	@Value("${konke.deviceCloud.appKey}")
	private String appKey;

	private final MongoTemplate mongoTemplate;

	public KonkeIotUtils( MongoTemplate mongoTemplate) {
		this.mongoTemplate = mongoTemplate;
	}

	public final static Map<String, String> actionMap = Map.of(
			"3", "SwitchOpt"
	);


	/**
	 * 判断设备是否在线
	 */
	public boolean getDeviceOnline(String ccuName, String devId){
		DeviceStatus one = mongoTemplate.findOne(Query.query(
				Criteria.where("ccuName").is(ccuName)
						.and("devId").is(devId)
		), DeviceStatus.class);

		return one != null && one.getStatus().containsKey("online") && "1".equals(one.getStatus().get("online").toString());
	}

	public String optDeviceOpen(String ccuName, String devId,String operateId){

		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;
		switch (operateId) {
			case "1":
			case "3":
			case "4":
			case "5":
			case "7":
			case "9":
			case "10":
			case "11":
			case "12":
			case "13":
			case "14":
			case "15":
			case "17":
			case "18":
			case "201":
			case "492":
			case "493":
			case "501":
			case "502":
			case "503":
			case "504":
			case "505":
			case "506":
			case "507":
			case "508":
			case "509":
			case "510":
			case "511":
			case "513":
			case "514":
			case "515":
			case "516":
			case "517":
			case "518":
			case "519":
			case "701":
				action = "SwitchOpt";
				break;
			case "1001":
				action = "MotorOpt";
				break;
			default:
				break;
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("SwitchOpt".equals(action)){
			opt.set("on", true);
		}else if("MotorOpt".equals(action)){
			opt.set("opt", "OPEN");
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}
	public String optDeviceClosed(String ccuName, String devId,String operateId){
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;
		switch (operateId) {
			case "1":
			case "3":
			case "4":
			case "5":
			case "7":
			case "9":
			case "10":
			case "11":
			case "12":
			case "13":
			case "14":
			case "15":
			case "17":
			case "18":
			case "201":
			case "492":
			case "493":
			case "501":
			case "502":
			case "503":
			case "504":
			case "505":
			case "506":
			case "507":
			case "508":
			case "509":
			case "510":
			case "511":
			case "513":
			case "514":
			case "515":
			case "516":
			case "517":
			case "518":
			case "519":
			case "701":
				action = "SwitchOpt";
				break;
			case "1001":
				action = "MotorOpt";
				break;
			default:
				break;
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}

		JSONObject opt = new JSONObject();
		if("SwitchOpt".equals(action)){
			opt.set("on", false);
		}else if("MotorOpt".equals(action)){
			opt.set("opt", "CLOSE");
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}

		return optAIDevice(ccuName, devId, action,opt.toString());
	}


	// 如何控制设备
	/**
	 * 1、查找设备是否存在
	 * 2、根据设备ID查询设备状态（判断是否已操作符合，比如已经开灯了）？？？
	 * 3、设备支持哪些操作？
	 * 4、根据设备ID操作设备
	 */
	public String optAIDevice(String ccuName, String devId, String action, String actionArg){
		log.info("optAIDevice....ccuName:{},devId:{},action:{},actionArg:{}",ccuName,devId,action, JSONUtil.parseObj(actionArg));
		JSONObject opt = new JSONObject();
		opt.set("action", action);
		opt.set("actionArg", JSONUtil.parseObj(actionArg));

		return optDevice(ccuName, devId, opt.toString());
	}

	/**
	 * {"action":"SwitchOpt","actionArg":{"on":true}}
	 */
	public String optDevice(String ccuName, String devId, String requestMessage){
		String url = baseUrl + "/1.0/app/ccu/" + ccuName + "/dev/" + devId + "/opt";
		log.info("KonkeIotServer optDevice url {}, param {}, appId {}, appKey {}", url, requestMessage, appId, appKey);
		String result2 = HttpRequest.post(url)
				.header("appId", appId)
				.header("appKey", appKey)
				.body(requestMessage)
				.execute().body();
		log.info("KonkeIotServer optDevice result {}", result2);
		return result2;
	}
}
