package com.ikonke.konkeaialibabamcp.aitools;

import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.service.cdc.spaces.SpacesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class CDCSpacesTools {

	private final SpacesService spacesService;

	public CDCSpacesTools(SpacesService spacesService) {
		this.spacesService = spacesService;
	}

	@Tool(description = "根据房间(场所)ID和日期查询该日期可预约情况")
	public JSONObject getAppointmentTimeByRoomId(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                             @ToolParam(description = "查询的日期，如：2025-08-12")String date,
	                                             @ToolParam(description = "查询的房间(场所)ID")String roomId,
	                                             @ToolParam(description = "查询的房间(场所)的子空间ID,可省略", required = false)String subspaceId){
		log.info("mcp调用--->getAppointmentTimeByRoomId..获取预约时间..sn:{},time:{},roomId:{},roomSubspaceId:{}",sn,date,roomId,subspaceId);
		return spacesService.getAppointmentTimeByRoomId(sn,date,roomId,subspaceId);
	}

	@Tool(description = "获取该房间(场所)ID下可使用的优惠卷")
	public JSONArray getUserSpacesCoupons(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                @ToolParam(description = "查询的房间(场所)ID")String roomId){
		log.info("mcp调用--->getUserCoupons..获取用户优惠券..sn:{},roomId:{}",sn,roomId);
		return spacesService.getUserCoupons(sn,roomId);
	}

	@Tool(description = "获取该房间(场所)ID下在某个时间段可使用的优惠卷")
	public JSONArray getUserSpacesCouponsByTime(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                               @ToolParam(description = "使用的开始时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 09:00:00")String beginTime,
	                                               @ToolParam(description = "使用的结束时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 10:30:00")String endTime,
	                                               @ToolParam(description = "查询的房间(场所)ID")String roomId){
		log.info("mcp调用--->getUserSpacesCouponsByTime..获取用户当前预约可用的优惠券..sn:{},roomId:{},beginTime:{},endTime:{}",sn,roomId,beginTime,endTime);
		return spacesService.getUserSpacesCouponsByTime(sn,roomId,beginTime,endTime);
	}

//	@Tool(description = "使用优惠卷预订房间(场所)")
//	public String bookingSpaces(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
//	                            @ToolParam(description = "使用的开始时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 09:00:00")String beginTime,
//	                            @ToolParam(description = "使用的结束时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 10:30:00")String endTime,
//	                            @ToolParam(description = "预约的房间(场所)ID")String roomId,
//	                            @ToolParam(description = "预约的房间(场所)下的子空间ID,若不是预约子空间可省略", required = false)String subspaceId,
//	                            @ToolParam(description = "使用的人数,必须大于0")int userQuantity,
//	                            @ToolParam(description = "使用的优惠券ID,不能为空")String couponsId){
//		log.info("mcp调用--->bookingOrder..预约订单..sn:{},beginTime:{},endTime:{},roomId:{},roomSubspaceId:{},userQuantity:{},couponId:{}",
//				sn,beginTime,endTime,roomId,subspaceId,userQuantity,couponsId);
//		try {
//			if(spacesService.bookingOrder(sn,beginTime,endTime,roomId,subspaceId,userQuantity,couponsId)){
//				return "预约成功";
//			}else{
//				return "预约失败";
//			}
//		}catch (StatefulException e){
//			return e.getMessage();
//		}
//	}
	@Tool(description = "自动查找优惠卷并使用优惠券预订房间(场所)")
	public String bookingSpaces(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                            @ToolParam(description = "使用的开始时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 09:00:00")String beginTime,
	                            @ToolParam(description = "使用的结束时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 10:30:00")String endTime,
	                            @ToolParam(description = "预约的房间(场所)ID")String roomId,
	                            @ToolParam(description = "预约的房间(场所)下的子空间ID,若不是预约子空间可省略", required = false)String subspaceId,
	                            @ToolParam(description = "使用的人数,必须大于0")int userQuantity){
		log.info("mcp调用--->bookingOrder..预约订单..sn:{},beginTime:{},endTime:{},roomId:{},roomSubspaceId:{},userQuantity:{}",
				sn,beginTime,endTime,roomId,subspaceId,userQuantity);
		try {
			if(spacesService.bookingOrder2(sn,beginTime,endTime,roomId,subspaceId,userQuantity)){
				return "预约成功";
			}else{
				return "预约失败";
			}
		}catch (StatefulException e){
			return e.getMessage();
		}
	}
}
