package com.ikonke.konkeaialibabamcp.service.cdc;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.entity.cdc.UserEntity;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CdcHttpUtils {

	public static Cache<String, String> CDCTokenCache = CacheUtil.newLRUCache(1024);

	@Value("${cdc.getOwnerUrl}")
	private String getOwnerUrl;

	@Value("${cdc.timeout}")
	private Integer timeout;

	@Autowired
	private ICDCTokenService tokenService;
	/**
	 * 获取用户信息
	 *
	 */
	public UserEntity getOwner(CDCToken bySn){
		String body = HttpRequest.get(getOwnerUrl)
				.header("X-token", bySn.getAccessToken())
				.header("gateway-id", bySn.getSn())
				.timeout(timeout)
				.execute().body();

		if(CDCTokenCache.get(bySn.getSn())!=null){
			String s = CDCTokenCache.get(bySn.getSn());
			return JSONUtil.toBean(s, UserEntity.class);
		}else{
			JSONObject jsonObject = JSONUtil.parseObj(body);
			if(jsonObject.getInt("code") == 200){
				UserEntity userEntity = JSONUtil.toBean(jsonObject.getJSONObject("data"), UserEntity.class);
				CDCTokenCache.put(bySn.getSn(),jsonObject.getJSONObject("data").toString());
				return userEntity;
			}else{
				return null;
			}
		}
	}


	/**
	 * get请求
	 */
	public String get(String url, String sn) {
		long start = System.currentTimeMillis();
		log.info("建发get请求：url：{}，sn:{}",url, sn);
		CDCToken bySn = tokenService.findBySn(sn);
		UserEntity userEntity = getOwner(bySn);
		String body = HttpRequest.get(url)
				.header("X-token",bySn.getAccessToken())
				.header("gateway-id",sn)
				.header("space-yr",userEntity.communityId)
				.header("communityId",userEntity.communityId)
				.header("space-phone",userEntity.phoneNum)
				.header("gateway",sn)
				.header("roomId",userEntity.roomInfo.roomId)
				.header("easId",userEntity.easId)
				.timeout(20000)//超时，毫秒
				.execute().body();
		log.info("建发get请求结果：url：{}，sn:{},body:{},耗时：{}",url, sn,body,System.currentTimeMillis()-start);
		return body;
	}

	public String post(String url, String sn,String body) {
		long start = System.currentTimeMillis();
		log.info("建发post请求：url：{}，sn:{},body:{}",url, sn,body);
		CDCToken bySn = tokenService.findBySn(sn);
		UserEntity userEntity = getOwner(bySn);
		String result = HttpRequest.post(url)
				.header("X-token",bySn.getAccessToken())
				.header("gateway-id",sn)
				.header("space-yr",userEntity.communityId)
				.header("communityId",userEntity.communityId)
				.header("space-phone",userEntity.phoneNum)
				.header("gateway",sn)
				.header("roomId",userEntity.roomInfo.roomId)
				.header("easId",userEntity.easId)
				.body(body)
				.timeout(20000)
				.execute().body();
		log.info("建发post请求结果：url：{}，sn:{},body:{},耗时：{}",url, sn,result,System.currentTimeMillis()-start);
		return result;
	}
}
