package com.ikonke.konkeaialibabamcp.controller;


import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import com.ikonke.konkeaialibabamcp.service.cdc.spaces.SpacesService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Slf4j
@RestController
@RequestMapping("/cdc")
public class CDCController {

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private SpacesService spacesService;

	@GetMapping("/synCDCToken")
	public boolean synCDCToken(@RequestParam(name = "token") String token,
	                           @RequestParam(name = "sn") String sn,
	                           @RequestParam(name = "ccuName") String ccuName){
		log.info("synCDCToken..同步CDCToken..token:{},sn:{},ccuName:{}",token,sn,ccuName);
		CDCToken bySn = tokenService.findBySn(sn);
		if(bySn==null){
			bySn = new CDCToken();
			bySn.setSn(sn);
			bySn.setAccessToken(token);
			bySn.setState(CDCToken.STATE_ENABLED);
			bySn.setCcuId(CcuUtils.getCcuName(ccuName));
			bySn.setCreateTime(LocalDateTime.now());
			tokenService.save(bySn);
		}else{
			if(bySn.getAccessToken().equals(token)
					&& bySn.getSn().equals(sn)
					&& bySn.getCcuId().equals(CcuUtils.getCcuName(ccuName))){
				return true;
			}else{
				CdcHttpUtils.CDCTokenCache.remove(sn);

				bySn.setAccessToken(token);
				bySn.setRefreshToken(bySn.getAccessToken());
				bySn.setState(CDCToken.STATE_ENABLED);
				bySn.setCreateTime(LocalDateTime.now());
				bySn.setCcuId(CcuUtils.getCcuName(ccuName));
				tokenService.updateById(bySn);
			}
		}
		return true;
	}

	@GetMapping("/getSpacesList")
	public JSONArray getSpacesList(@RequestParam(name = "sn") String sn){
		log.info("getSpacesList..获取空间列表..sn:{}",sn);
		JSONArray all = spacesService.findAll(sn);
		if(!all.isEmpty()){
			return all;
		}else{
			return null;
		}
	}


	@GetMapping("/getAppointmentTimeByRoomId")
	public JSONObject getAppointmentTimeByRoomId(@RequestParam(name = "sn")String sn,
	                                             @RequestParam(name = "time")String time,
	                                             @RequestParam(name = "roomId")String roomId,
	                                             @RequestParam(name = "roomSubspaceId",required = false)String roomSubspaceId){
		log.info("getAppointmentTimeByRoomId..获取预约时间..sn:{},time:{},roomId:{},roomSubspaceId:{}",sn,time,roomId,roomSubspaceId);
		return spacesService.getAppointmentTimeByRoomId(sn,time,roomId,roomSubspaceId);
	}

}
