package com.ikonke.konkeaialibabamcp.service;

import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Device;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Region;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Room;
import com.ikonke.konkeaialibabamcp.entity.mysql.SynDevice;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ISynDeviceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
public class SycDeviceService {

	@Autowired
	private ISynDeviceService synDeviceService;
	@Autowired
	private MongoTemplate mongoTemplate;

	public JSONArray findByCcu(String ccuName){
		log.info("findByCcu..根据主机号查询设备..ccuName:{}",ccuName);
		QueryWrapper<SynDevice> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);
		List<SynDevice> list = synDeviceService.list(wrapper);

		JSONArray jsonArray = null;
		if(!list.isEmpty()){
			jsonArray = new JSONArray();
			for (SynDevice synDevice : list) {
				JSONObject jsonObject = new JSONObject();
				jsonObject.set("deviceId", synDevice.getDeviceId());
				jsonObject.set("deviceName", synDevice.getDeviceName());
				jsonObject.set("roomId", synDevice.getRoomId());
				jsonObject.set("roomName", synDevice.getRoomName());
				jsonObject.set("operateId", synDevice.getOperateId());

				jsonArray.set(jsonObject);
			}
		}
		return jsonArray;
	}

	public boolean synchronousDevice(String ccuName) {
		log.info("synchronousDevice..同步设备..ccuName:{}",ccuName);

		//查询房间信息
		Query regionQuery = new Query(Criteria.where("ccuName").is(ccuName));
		List<Region> region = mongoTemplate.find(regionQuery, Region.class);
		if (region.size() != 1) {
			log.error("主机：{} 没有找到匹配的房间",ccuName);
			throw new StatefulException(-1, "没有房间信息");
		}
		List<Room> rooms = region.get(0).getRooms();
		//查询设备信息
		Query regionQuery2 = new Query(Criteria.where("ccuName").is(ccuName));
		List<Device> device = mongoTemplate.find(regionQuery2, Device.class);
		if (device.isEmpty()) {
			log.error("主机：{} 没有找到匹配的设备",ccuName);
			throw new StatefulException(-2, "没有设备信息");
		}
		//查询场景 todo

		List<SynDevice> synDeviceList = getSynDevices(ccuName, device, rooms);
		log.debug("要保存的设备：{}", JSONUtil.toJsonStr(synDeviceList));

		synDeviceService.remove(new QueryWrapper<SynDevice>().eq("ccuId", ccuName));
		return synDeviceService.saveBatch(synDeviceList);
	}

	@NotNull
	private static List<SynDevice> getSynDevices(String ccuName, List<Device> device, List<Room> rooms) {
		List<SynDevice> synDeviceList = new ArrayList<>();
		for(Device d : device){
			if(d.getRoomId() == -1){
				continue;
			}
			SynDevice synDevice = new SynDevice();
			synDevice.setDeviceId(d.getDevId());
			synDevice.setDeviceName(d.getName());
			synDevice.setOperateId(String.valueOf(d.getRealType()));
			synDevice.setRoomId(d.getRoomId());
			for(Room room : rooms){
				if(room.getId().equals(d.getRoomId())){
					synDevice.setRoomName(room.getName());
				}
			}
			synDevice.setType(1);
			synDevice.setCcuId(ccuName);

			synDeviceList.add(synDevice);
		}
		return synDeviceList;
	}

}
