package com.ikonke.konkeaialibabamcp.mapper.mysql;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ikonke.konkeaialibabamcp.entity.mysql.SynDevice;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface SynDeviceMapper extends BaseMapper<SynDevice> {

	@Select("SELECT * FROM syn_device WHERE ccuId = #{ccuId}")
	List<SynDevice> findByCcu(@Param("ccuId")String ccuId);

	@Select("SELECT * FROM syn_device WHERE deviceName LIKE CONCAT('%',#{deviceName},'%') AND roomName LIKE CONCAT('%',#{roomName},'%')")
	List<SynDevice> findByDeviceNameAndRoomName(@Param("deviceName")String deviceName, @Param("roomName")String roomName);

}
