package com.ikonke.konkeaialibabamcp.service.mongdbservice;

import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Device;
import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Region;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Room;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class DeviceStatusService {

	private final MongoTemplate mongoTemplate;
	public DeviceStatusService(MongoTemplate mongoTemplate) {
		this.mongoTemplate = mongoTemplate;
	}

	/**
	 * 查询设备状态
	 */
	public DeviceStatus findUserByUserId(@ToolParam(description = "主机号") String ccuName,
	                                     @ToolParam(description = "设备ID") Integer devId) {
		log.info("DeviceStatusUtil:findUserByUserId....ccuName:{},devId:{}",ccuName,devId);
		return mongoTemplate.findOne(Query.query(
				Criteria.where("ccuName").is(ccuName)
						.and("devId").is(devId)
		), DeviceStatus.class);
	}

	/**
	 * 根据主机、房间名、设备名查询设备状态
	 */
	public DeviceStatus findByName(String ccuName,String roomName,String deviceName) {
		log.info("主机：{},查询房间：{} ,下的设备: {} ,状态",ccuName,roomName,deviceName);
		// 第一步：根据房间名称查找 Region 获取 ccuName
		Query regionQuery = new Query(Criteria.where("ccuName").is(ccuName));
		List<Region> region = mongoTemplate.find(regionQuery, Region.class);
		log.info("region:{}", JSONUtil.toJsonStr(region));
		if (region.size() != 1) {
			log.error("主机：{} 没有找到匹配的房间",ccuName);
			return null; // 没有找到匹配的房间
		}
		Integer roomId = null;
		List<Room> rooms = region.get(0).getRooms();
		for (Room room : rooms){
			if (room.getName().contains(roomName)){
				roomId = room.getId();
			}
		}
		if(roomId==null){
			log.error("主机：{} 没有找到匹配的房间：{}",ccuName,roomName);
			return null;
		}
		// 查询房间下的设备
		Integer devId = null;
		Query regionQuery2 = new Query(Criteria.where("ccuName").is(ccuName)
				.and("roomId").is(roomId)
				.and("name").regex(".*" + deviceName + ".*", "i"));
		List<Device> device = mongoTemplate.find(regionQuery2, Device.class);
		if (device.size() != 1) {
			log.error("主机：{} 下的设备：{}有{}个",ccuName,deviceName,device.size());
			return null;
		}
		devId = device.get(0).getDevId();
		if(devId==null){
			log.error("主机：{} 下的设备：{}的devId为空",ccuName,deviceName);
			return null;
		}
		//查询设备状态
		return mongoTemplate.findOne(Query.query(
				Criteria.where("ccuName").is(ccuName)
						.and("devId").is(devId)
		), DeviceStatus.class);
	}
}
