package com.ikonke.konkeaialibabamcp.controller;

import cn.hutool.json.JSONArray;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping("/deviceController")
public class DeviceController {


	@Autowired
	private SycDeviceService sycDeviceService;

	@GetMapping("/findSycDeviceByCcu")
	public JSONArray findSycDeviceByCcu(@RequestParam(name = "ccuName") String ccuName){
		log.info("findSycDeviceByCcu..根据主机号查询设备..ccuName:{}",ccuName);
		return sycDeviceService.findByCcu(ccuName);
	}

	@GetMapping("/synchronousDevice")
	public Boolean synchronousDevice(@RequestParam(value = "ccuName") String ccuName) {
		log.info("synchronousDevice..同步设备..ccuName:{}",ccuName);
		return sycDeviceService.synchronousDevice(ccuName);
	}


}
