package com.ikonke.konkeaialibabamcp.controller.open;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.controller.param.ResultResp;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping("/device")
public class DeviceController2 {

	@Autowired
	private KonkeIotUtils konkeIotServer;
	@Autowired
	private SycDeviceService sycDeviceService;

	@GetMapping("/triggerScene")
	public ResultResp triggerScene(@RequestParam(value = "ccuName")String ccuName,
	                               @RequestParam(value = "sceneId")String sceneId){
		log.info("triggerScene--->根据主机号和场景ID触发场景....ccuName:{},sceneId:{}",ccuName,sceneId);
		return ResultResp.setDate(konkeIotServer.optScene(CcuUtils.getCcuName(ccuName), sceneId));
	}

	@GetMapping("/saveTemporaryScene")
	public ResultResp saveTemporaryScene(@RequestParam(value = "sn") String sn,
							@RequestParam(value = "ccuName") String ccuName,
	                        @RequestParam(value = "sceneId") String sceneId) {
		log.info("saveTemporaryScene..临时场景存储..ccuName:{},sceneId:{},sn:{}",ccuName,sceneId,sn);

		if(konkeIotServer.saveTemporaryScene(sn,ccuName, sceneId)){
			sycDeviceService.synchronousDevice(ccuName);
			return ResultResp.setDate("保存成功");
		}else{
			return ResultResp.setBadDate("保存失败");
		}
	}

	@DeleteMapping("/delScene")
	public ResultResp delScene(@RequestParam("sceneId") String sceneId,
	                        @RequestParam("sn") String sn,
	                        @RequestParam(value = "ccuName") String ccuName) {
		log.info("delScene..删除场景..ccuName:{},temporarySceneId:{},sn:{}",ccuName,sceneId,sn);

		boolean b = konkeIotServer.delScene(sn,ccuName,sceneId);

		if(b){
			return ResultResp.setDate("删除成功");
		}else{
			return ResultResp.setBadDate("删除失败");
		}
	}

}
