package com.ikonke.konkeaialibabamcp.service.cdc.spaces;

import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SpacesService {

	@Value("${cdc.url}")
	private String cdcUrl;
	@Value("${cdc.getListSpacesRoomUrl}")
	private String getListSpacesRoomUrl;
	@Value("${cdc.getSpacesRoomDetailUrl}")
	private String getSpacesRoomDetailUrl;
	@Value("${cdc.getSpacesRoomBookingUrl}")
	private String getSpacesRoomBookingUrl;

	@Autowired
	private CdcHttpUtils cdcHttpUtils;

	// 查询所有空间
	public JSONArray findAll(String sn) {
		// 小区功能区列表
		String s = cdcHttpUtils.get(getListSpacesRoomUrl, sn);
		JSONObject spacesJson = new JSONObject(s);
		if(spacesJson.getInt("code") != 200){
			throw new StatefulException(51, "查询会所空间列表失败");
		}else{
			JSONArray data = spacesJson.getJSONArray("data");
			JSONArray spacesList = data.getJSONArray(1);
			JSONArray response = new JSONArray();
			for( int i = 0; i < spacesList.size(); i++){
				JSONObject response_spaces = new JSONObject();
				JSONObject jsonObject = spacesList.getJSONObject(i);
				String status = jsonObject.getStr("status");//0=正常；1=维护中(任何时段都不可预定)
				String name = jsonObject.getStr("name");//空间名
				String type = jsonObject.getStr("type");//1=共享型，2=独占式，3=仅展示，4=跳转小程序
				String id = jsonObject.getStr("id");
				Integer main_userCount = jsonObject.getInt("userCount");//当前里面的用户数，每日凌晨改成0
				if(main_userCount==null){
					main_userCount = 0;
				}
				String subspaceType = jsonObject.getStr("subspaceType");//0:单独空间 1:内分子空间

				response_spaces.set("场所ID",id);
				response_spaces.set("场所名称",name);
				response_spaces.set("当前场所里面的用户数",main_userCount);

				if("0".equals(status) && ("1".equals(type) || "2".equals(type)) && "1".equals(subspaceType)){
					//查详情-子空间
					String s1 = cdcHttpUtils.get(getSpacesRoomDetailUrl + id, sn);
					JSONObject spacesRoomDetailJson = JSONUtil.parseObj(s1);
					if(spacesRoomDetailJson.getInt("code") == 200){
						JSONObject result = spacesRoomDetailJson.getJSONObject("data");
						Integer userCount = result.getInt("userCount");//当前里面的用户数，每日凌晨改成0
						if(userCount == null){
							userCount = 0;
						}
						Integer maxUser = result.getInt("maxUser");//推荐使用最多人数
						JSONArray subspacePd = result.getJSONArray("subspacePd");//子空间
						JSONArray child = new JSONArray();
						for( int j = 0; j < subspacePd.size(); j++){
							JSONObject jsonObject1 = subspacePd.getJSONObject(j);
							String subspacePdName = jsonObject1.getStr("name");
							String subspacePdId = jsonObject1.getStr("id");

							JSONObject childJsonObject = new JSONObject();
							childJsonObject.set("房间名称", subspacePdName);
							childJsonObject.set("房间ID", subspacePdId);
							childJsonObject.set("当前房间里面的用户数", userCount);
							child.set(childJsonObject);
						}
						response_spaces.set("subspacePd", child);
					}
				}
				response.set(response_spaces);
			}

			return response;

		}

	}
}
