package com.ikonke.konkeaialibabamcp.controller;


import cn.hutool.json.JSONArray;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import com.ikonke.konkeaialibabamcp.service.cdc.spaces.SpacesService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Slf4j
@RestController
@RequestMapping("/cdc")
public class CDCController {

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private SpacesService spacesService;

	@GetMapping("/synCDCToken")
	public boolean synCDCToken(@RequestParam(name = "token") String token,
	                           @RequestParam(name = "sn") String sn,
	                           @RequestParam(name = "ccuName") String ccuName){
		log.info("synCDCToken..同步CDCToken..token:{},sn:{},ccuName:{}",token,sn,ccuName);
		CDCToken bySn = tokenService.findBySn(sn);
		if(bySn==null){
			bySn = new CDCToken();
			bySn.setSn(sn);
			bySn.setAccessToken(token);
			bySn.setState(CDCToken.STATE_ENABLED);
			bySn.setCcuId(ccuName);
			bySn.setCreateTime(LocalDateTime.now());
			tokenService.save(bySn);
		}else{
			CdcHttpUtils.CDCTokenCache.remove(sn);

			bySn.setAccessToken(token);
			bySn.setRefreshToken(bySn.getAccessToken());
			bySn.setState(CDCToken.STATE_ENABLED);
			bySn.setCreateTime(LocalDateTime.now());
			bySn.setCcuId(ccuName);
			tokenService.updateById(bySn);
		}
		return true;
	}

	@GetMapping("/getSpacesList")
	public JSONArray getSpacesList(@RequestParam(name = "sn") String sn){
		log.info("getSpacesList..获取空间列表..sn:{}",sn);
		return spacesService.findAll(sn);
	}

}
