package com.ikonke.konkeaialibabamcp;

import com.ikonke.konkeaialibabamcp.aitools.DeviceTools;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@MapperScan("com.ikonke.konkeaialibabamcp.mapper.mysql")
@SpringBootApplication
public class KonkeAiAlibabaMcpApplication {

	public static void main(String[] args) {
		SpringApplication.run(KonkeAiAlibabaMcpApplication.class, args);
	}

	@Bean
	public ToolCallbackProvider tools(DeviceTools deviceTools) {
		return MethodToolCallbackProvider.builder().toolObjects(deviceTools).build();
	}

}
