package com.ikonke.konkeaialibabamcp.mapper.mysql;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ikonke.konkeaialibabamcp.entity.mysql.TemporaryScene;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface TemporarySceneMapper extends BaseMapper<TemporaryScene> {

	@Delete("DELETE t1 FROM temporary_scene t1 INNER JOIN temporary_scene t2 WHERE t1.ccuId = t2.ccuId AND ( t1.createTime < t2.createTime OR ( t1.createTime = t2.createTime AND t1.id < t2.id ) )")
	int delByCreateTime();


	/**
	 * 如果用户自己保存，会将这条数据删除，若没删除，说明用户没有说保存，那么就需要删除，且要把主机中的数据也删除
	 * @return
	 */
	@Delete("DELETE FROM temporary_scene WHERE createTime < DATE_SUB(NOW(), INTERVAL 1 HOUR)")
	int delOld();

	@Select("SELECT * FROM temporary_scene WHERE createTime < DATE_SUB(NOW(), INTERVAL 1 HOUR)")
	List<TemporaryScene> queryOld();
}
