package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class WebSocketUtil {

	@Value("${webSocket.url}")
	private String webSocketUrl;

	private final static String getWebSocketUrl = "ws/getWebSocket?sn=";
	private final static String sendToSingleUrl = "ws/sendToSingle";

	public boolean getWebSocket(String sn){
		String url =  webSocketUrl + getWebSocketUrl + sn;
		String body = HttpRequest.get(url)
				.execute().body();
		return "true".equals(body);
	}


	public void sendToSingle(String sn,String  message){
		JSONObject param = new JSONObject();
		param.set("sn", sn);
		param.set("message", message);

		HttpRequest.post(webSocketUrl + sendToSingleUrl)
				.body(param.toString())
				.execute().body();
	}

}
