package com.ikonke.konkeaialibabamcp.aitools;

import com.ikonke.konkeaialibabamcp.utils.WeatherUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class WeatherTools {

	private final WeatherUtils weatherUtils;
	public WeatherTools(WeatherUtils weatherUtils) {
		this.weatherUtils = weatherUtils;
	}


	@Tool(description = "天气相关：根据城市名查询当前的天气")
	public String getWeatherNow(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("mcp调用--->根据城市名查询当前的天气....city:{}",city);
		return weatherUtils.getWeatherNow(city);
	}
	@Tool(description = "天气相关：根据城市名查询未来24小时的天气")
	public String getWeatherHourly(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("mcp调用--->根据城市名查询未来24小时的天气...city:{}",city);
		return weatherUtils.getWeatherHourly(city);
	}
	@Tool(description = "天气相关：根据城市名查询未来7天的天气")
	public String getWeatherDaily(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("mcp调用--->根据城市名查询未来7天的天气....city:{}",city);
		return weatherUtils.getWeatherDaily(city);
	}

}
