package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class WebSocketUtil {

	private final static String getWebSocketUrl = "http://127.0.0.1:9997/ws/getWebSocket?sn=";
	private final static String sendToSingleUrl = "http://127.0.0.1:9997/ws/sendToSingle";

	public boolean getWebSocket(String sn){
		String url =  getWebSocketUrl + sn;
		String body = HttpRequest.get(url)
				.execute().body();
		return "true".equals(body);
	}


	public void sendToSingle(String sn,String  message){
		JSONObject param = new JSONObject();
		param.set("sn", sn);
		param.set("message", message);

		HttpRequest.post(sendToSingleUrl)
				.body(param.toString())
				.execute().body();
	}

}
