package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.extra.pinyin.PinyinUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class PinyinUtils {

	String[] englishPinYin26={
			"EI1", "BI4", "SEI4", "DI4", "YI4", "EFU1", "JI4",
			"EIQI1", "AI4", "JEI4", "KEI4", "EOU1", "EMEN1", "EN1",
			"OU1", "PI1", "KIU1", "A4", "ESI1", "TI4",
			"YOU4", "WEI4", "DABULIU3", "EKESI1", "WAI4", "ZEI4"
	};

	String englishString26="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	String numberStringArabic="0123456789";
	String numberString="零一二三四五六七八九十百点";
	String specialHanziString="年级班分";
	String myCharAll = numberString + specialHanziString;

	List<String> numberPinYin=new ArrayList<String>(20);//数字的拼音(10)
	List<String> specialHanziPinYin=new ArrayList<String>(10);//特定汉字集的拼音（除了中文的数字之外的）
	List<String> myCharAllPinYin=new ArrayList<String>(40);//所有拼音的集合

	boolean fuzzyMatching=true;//是否开启模糊匹配功能

	public PinyinUtils(boolean fuzzyMatching){
		this.fuzzyMatching = fuzzyMatching;
		init();
	}

	public void init()
	{
		try{
			String str ;


			str = numberString;//数字
			for (int i = 0; i < str.length(); i++) {
				char c = str.charAt(i);

				numberPinYin.add(PinyinUtil.getPinyin(c));
			}

			str = specialHanziString;//汉字
			for (int i = 0; i < str.length(); i++) {
				char c = str.charAt(i);

				specialHanziPinYin.add(PinyinUtil.getPinyin(c));
			}

			myCharAllPinYin.addAll(numberPinYin);
			myCharAllPinYin.addAll(specialHanziPinYin);

		} catch (Exception e){
			e.printStackTrace();
		}
	}

	public String changeOurWordsWithPinyin(String input){
		String output=input;
		try{

			//处理符号：不关注符合，遇到，就去掉（要保留小数点）
			output = changeWordProcessSignal(output);

			//处理英文字母：转大写
			output = changeWordProcessEnglish(output);

			//所有汉字进行相似替换
			log.info("input="+input);

			int index;
			String str;
			String strChanged;
			StringBuilder strBuilder = new StringBuilder();
			for(index=0; index<input.length(); index++){
				str = input.substring(index,index+1);
				strChanged = changeOneWord(str);
				strBuilder.append(strChanged);
			}

			output=strBuilder.toString();
			log.info("output="+output);

		} catch (Exception e){
			e.printStackTrace();
		}

		return output;
	}

	//尾字如果是汉字，进行拼音相同字的替换（零不能替换，可以先转换为0）
	public String changeOneWord(String strInput){
		//若已经在目标集合中了，就不需要转换了
		if(numberString.contains(strInput) || numberStringArabic.contains(strInput)){
			log.info("is number");
			return strInput;
		} else if(specialHanziString.contains(strInput)){
			log.info("is specialHanziString");
			return strInput;
		}

		String strChanged;
		List<String> listEnglishPinYin = new ArrayList<String>();

		strChanged = changeWord(strInput, numberPinYin, numberString);
		if(numberString.contains(strChanged)){
			log.info("strChanged="+strChanged);
			return strChanged;
		}

		return changeWord(strInput, specialHanziPinYin,  specialHanziString);
	}


	private String changeWord(String strInput, List<String> listPinYin, String strSource) {

		//先判断输入，是什么类型的字符：数字、字母、汉字
		String strOutput = "";

		String str = strInput.substring(0, 1);
		String strPinyin = "";
		boolean flagGetPinyin = false;

		try {

			if (str.matches("^[A-Z]{1}$")) {

				strPinyin = englishPinYin26[englishString26.indexOf(str)];
				log.info("str="+str+" Pinyin="+strPinyin);
				flagGetPinyin = true;
			} else if (str.matches("^[0-9]{1}$")) {

				strPinyin = numberPinYin.get(numberString.indexOf(str));
				log.info("str="+str+" Pinyin="+strPinyin);
				flagGetPinyin = true;
			} else if (str.matches("^[\u4e00-\u9fa5]{1}$")) {
				char c = str.charAt(0);

				strPinyin = PinyinUtil.getPinyin(c);
				flagGetPinyin = true;
			}


			if(flagGetPinyin) {
				//在目标拼音集合中查找匹配项
				int num = listPinYin.indexOf(strPinyin);
				if (num >= 0) { //拼音精确匹配成功
					return strSource.substring(num, num + 1);
				} else {
					if (fuzzyMatching) {//若开启了模糊匹配
						//声母替换
						String strPinyinFuzzy = new String(strPinyin);//避免修改原字符串
						strPinyinFuzzy = replaceHeadString(strPinyinFuzzy);
						boolean flagReplacedHeadString = (strPinyinFuzzy == null) ? false : true;
						if (flagReplacedHeadString) {
							num = listPinYin.indexOf(strPinyinFuzzy);
							if (num >= 0) { //拼音模糊匹配成功
								log.info("strPinyinFuzzy=" + strPinyinFuzzy);
								return strSource.substring(num, num + 1);
							}
						}
						//韵母替换
						strPinyinFuzzy = new String(strPinyin);//避免修改原字符串，不使用声母替换后的字符串
						strPinyinFuzzy = replaceTailString(strPinyinFuzzy);
						boolean flagReplacedTailString = (strPinyinFuzzy == null) ? false : true;
						if (flagReplacedTailString) {
							num = listPinYin.indexOf(strPinyinFuzzy);
							if (num >= 0) { //拼音模糊匹配成功
								log.info("strPinyinFuzzy=" + strPinyinFuzzy);
								return strSource.substring(num, num + 1);
							}
						}
						//声母韵母都替换
						if (flagReplacedHeadString && flagReplacedTailString) {
							strPinyinFuzzy = replaceHeadString(strPinyinFuzzy);
							num = listPinYin.indexOf(strPinyinFuzzy);
							if (num >= 0) { //拼音模糊匹配成功
								log.info("strPinyinFuzzy=" + strPinyinFuzzy);
								return strSource.substring(num, num + 1);
							}
						}
					}


				}
			}


		}catch (Exception e){
			e.printStackTrace();
		}
		return flagGetPinyin ? strPinyin : strInput;
	}


	public String changeWordProcessSignal(String strInput){
		String strOutput = strInput;
		//去掉 ，。空格-
		strOutput = strOutput.replace("，", "");
		strOutput = strOutput.replace("。", "");
		strOutput = strOutput.replace("-", "");
		strOutput = strOutput.replace(" ", "");

		return strOutput;
	}

	public String changeWordProcessEnglish(String strInput){
		String strOutput = strInput;
		//转大写
		strOutput = strOutput.toUpperCase();

		return strOutput;
	}


	private String replaceHeadString(String strPinyin){
		//声母替换
		String strReplaced = null;
		if(strPinyin.contains("ZH")){
			strReplaced = strPinyin.replace("ZH", "Z");
		} else if(strPinyin.contains("CH")){
			strReplaced = strPinyin.replace("CH", "C");
		} else if(strPinyin.contains("SH")){
			strReplaced = strPinyin.replace("SH", "S");
		} else if(strPinyin.contains("Z")){
			strReplaced = strPinyin.replace("Z", "ZH");
		} else if(strPinyin.contains("C")){
			strReplaced = strPinyin.replace("C", "CH");
		} else if(strPinyin.contains("S")){
			strReplaced = strPinyin.replace("S", "SH");
		} else if(strPinyin.contains("L")){
			strReplaced = strPinyin.replace("L", "N");
		} else if(strPinyin.indexOf('N')==0){ //n有在后面的，n只在做声母时易混
			strReplaced = strPinyin.replace("N", "L");
		} else {
			return null;
		}
		return strReplaced;//flagReplaced;
	}
	private String replaceTailString(String strPinyin) {
		// 韵母替换
		String strReplaced = null;
		if (strPinyin.contains("ANG")) {
			strReplaced = strPinyin.replace("ANG", "AN");
		} else if (strPinyin.contains("ENG")) {
			strReplaced = strPinyin.replace("ENG", "EN");
		} else if (strPinyin.contains("ING")) {
			strReplaced = strPinyin.replace("ING", "IN");
		} else if (strPinyin.contains("AN")) {
			strReplaced = strPinyin.replace("AN", "ANG");
		} else if (strPinyin.contains("EN")) {
			strReplaced = strPinyin.replace("EN", "ENG");
		} else if (strPinyin.contains("IN")) {
			strReplaced = strPinyin.replace("IN", "ING");
		} else {
			return null;
		}
		return strReplaced;
	}
}
