package com.ikonke.konkeaialibabamcp.service.cdc.robot;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.entity.cdc.UserEntity;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CommunityRobot {

	@Value("${cdc.robot.bookingLitterRobot}")
	private String bookingLitterRobotUrl;

	@Value("${cdc.robot.bookingDeliveryRobot}")
	private String bookingDeliveryRobotUrl;

	@Autowired
	private CdcHttpUtils cdcHttpUtils;

	public String bookingLitterRobot(String sn,String data){

		return "已成功预约垃圾回收机器人,预计在"+data+"上门,请业主做好准备,开机密码是："+ RandomUtil.randomString(5);

//		UserEntity userEntity = cdcHttpUtils.getOwner(sn);
//
//		JSONObject body = new JSONObject();
//		body.set("buildingId",userEntity.getOwnerRoom().getBuildingId());
//		body.set("roomId",userEntity.getOwnerRoom().getRoomId());
//
//		String post = cdcHttpUtils.post(bookingLitterRobotUrl, sn, body.toString());
//		JSONObject jsonObject = JSONUtil.parseObj( post);
//		if(jsonObject.getInt("code") == 200){
//			return "预约垃圾回收机器人成功";
//		}else{
//			log.error("bookingLitterRobotUrl error:{}",jsonObject.getStr("msg"));
//			return "预约垃圾回收机器人失败";
//		}
	}

	public String bookingDeliveryRobot(String sn,String data){

		return "已成功预约配送机器人,预计在"+data+"上门,请业主做好准备,开机密码是："+ RandomUtil.randomString(5);

//		UserEntity userEntity = cdcHttpUtils.getOwner(sn);
//
//		//1、获取初始点位：发货人
//		//2、获取业主的点位：收货人
//
//		JSONObject body = new JSONObject();
//		body.set("senderId","");
//		body.set("senderName","");
//		body.set("senderPhone","");
//		body.set("startAddress","");
//		body.set("startAddressId","");
//		body.set("consigneeName","");
//		body.set("consigneePhone","");
//		body.set("endAddress","");
//		body.set("endAddressId","");
//		body.set("waitTime","");
//
//		String post = cdcHttpUtils.post(bookingDeliveryRobotUrl, sn, body.toString());
//		JSONObject jsonObject = JSONUtil.parseObj( post);
//		if(jsonObject.getInt("code") == 200){
//			return "预约配送机器人成功";
//		}else{
//			log.error("bookingDeliveryRobotUrl error:{}",jsonObject.getStr("msg"));
//			return "预约配送机器人失败";
//		}
	}

	/**
	 * 获取机器人配送的点位
	 * thirdType:PT表示普通点位，ROBOT_STANDBY起始点
	 */
	public String getPoints(String sn,String ownerId,String thirdType,String type){
		if(StrUtil.isBlank(thirdType)){
			thirdType = "PT";
		}
		String url = bookingDeliveryRobotUrl + "?thirdType="+thirdType;
		if(StrUtil.isNotBlank(ownerId)){
			url = url + "&ownerId=" + ownerId;
		}
		if(StrUtil.isNotBlank(type)){
			url = url + "&type=" + type;
		}
		String s = cdcHttpUtils.get(url, sn);
		JSONObject jsonObject = JSONUtil.parseObj(s);
		if(jsonObject.getInt("code") == 200){
			JSONArray data = jsonObject.getJSONArray("data");
		}
		return "";
	}

}
