//package com.ikonke.konkeaialibabamcp.aitools;
//
//
//import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
//import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
//import com.ikonke.konkeaialibabamcp.service.mongdbservice.DeviceStatusService;
//import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
//import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.ai.tool.annotation.Tool;
//import org.springframework.ai.tool.annotation.ToolParam;
//import org.springframework.stereotype.Service;
//
//@Slf4j
//@Service
//public class DeviceTools {
//
//	private final DeviceStatusService deviceStatusUtil;
//	private final KonkeIotUtils konkeIotServer;
//	private final SycDeviceService sycDeviceService;
//
//	public DeviceTools(DeviceStatusService deviceStatusUtil, KonkeIotUtils konkeIotServer, SycDeviceService sycDeviceService){
//		this.deviceStatusUtil = deviceStatusUtil;
//		this.konkeIotServer = konkeIotServer;
//		this.sycDeviceService = sycDeviceService;
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID查询设备状态信息.")
//	public DeviceStatus findDeviceState(@ToolParam(description = "主机号") String ccuName,
//	                                    @ToolParam(description = "设备ID") Integer devId) {
//		log.info("mcp调用--->根据主机号和设备ID查询设备状态信息....ccuName:{},devId:{}",ccuName,devId);
//		return deviceStatusUtil.findUserByUserId(CcuUtils.getCcuName(ccuName), devId);
//	}
//	@Tool(description = "智能家居相关：根据主机号同步设备")
//	public boolean synchronousDevice(@ToolParam(description = "主机号")String ccuName){
//		log.info("mcp调用--->根据主机号同步设备....ccuName:{}",ccuName);
//		return sycDeviceService.synchronousDevice(CcuUtils.getCcuName(ccuName));
//	}
//
//	//==============================设备控制=============================================
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:打开设备")
//	public String optDeviceOpen(@ToolParam(description = "主机号")String ccuName,
//	                            @ToolParam(description = "设备ID")String devId,
//	                            @ToolParam(description = "设备类型ID")String typeId){
//		log.info("mcp调用--->根据主机号和设备ID控制打开设备....ccuName:{},devId:{},type:{}",ccuName,devId,typeId);
//		return konkeIotServer.optDeviceOpen(CcuUtils.getCcuName(ccuName), devId, typeId);
//	}
//	@Tool(description = "智能家居相关：根据主机号和多个设备ID批量控制:打开设备")
//	public String batchOptDeviceOpen(@ToolParam(description = "主机号")String ccuName,
//	                            @ToolParam(description = "设备ID,多个使用逗号隔开")String devIds){
//		log.info("mcp调用--->根据主机号和多个设备ID与设备类型ID批量控制....ccuName:{},devIds:{}",ccuName,devIds);
//		return konkeIotServer.batchOptDeviceOpen(CcuUtils.getCcuName(ccuName), devIds);
//	}
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:关闭设备")
//	public String optDeviceClosed(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "设备ID")String devId,
//	                              @ToolParam(description = "设备类型ID")String typeId){
//		log.info("mcp调用--->根据主机号和设备ID控制关闭设备....ccuName:{},devId:{},type:{}",ccuName,devId,typeId);
//		return konkeIotServer.optDeviceClosed(CcuUtils.getCcuName(ccuName), devId, typeId);
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置亮度")
//	public String setBrightness(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "设备ID")String devId,
//	                              @ToolParam(description = "设备类型ID")String typeId,
//	                            @ToolParam(description = "设置的亮度百分比大小,范围是0-100")int brightness){
//		log.info("mcp调用--->根据主机号和设备ID控制设备亮度....ccuName:{},devId:{},type:{},brightness:{}",ccuName,devId,typeId,brightness);
//		return konkeIotServer.setBrightness(CcuUtils.getCcuName(ccuName), devId, typeId,brightness);
//	}
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置色温")
//	public String setColourTemperature(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "设备ID")String devId,
//	                              @ToolParam(description = "设备类型ID")String typeId,
//	                                   @ToolParam(description = "设置的色温百分比大小,范围是0-100")int colourTemperature){
//		log.info("mcp调用--->根据主机号和设备ID控制设备的色温....ccuName:{},devId:{},type:{},colourTemperature:{}",ccuName,devId,typeId,colourTemperature);
//		return konkeIotServer.setColourTemperature(CcuUtils.getCcuName(ccuName), devId, typeId,colourTemperature);
//	}
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置显示的颜色")
//	public String setColor(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "设备ID")String devId,
//	                              @ToolParam(description = "设备类型ID")String typeId,
//	                       @ToolParam(description = "要设置的颜色,支持的颜色：Red,Yellow,Blue,Green,White,Black,Cyan,Purple,Orange,Pink,Violet,Magenta,Indigo,SlateBlue,DarkBlue,SkyBlue,DarkCyan,Beige,Brown")String color){
//		log.info("mcp调用--->根据主机号和设备ID控制设备的颜色....ccuName:{},devId:{},type:{},color:{}",ccuName,devId,typeId,color);
//		return konkeIotServer.setColor(CcuUtils.getCcuName(ccuName), devId, typeId,color);
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制:暂停设备.只支持窗帘类型")
//	public String setPause(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "设备ID")String devId,
//	                              @ToolParam(description = "设备类型ID")String typeId){
//		log.info("mcp调用--->根据主机号和设备ID控制暂停设备....ccuName:{},devId:{},type:{}",ccuName,devId,typeId);
//		return konkeIotServer.setPause(CcuUtils.getCcuName(ccuName), devId, typeId);
//	}
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制设备:移动位置.只支持窗帘电机(CURTAIN_MOTOR)类型")
//	public String setMove(@ToolParam(description = "主机号")String ccuName,
//	                       @ToolParam(description = "设备ID")String devId,
//	                       @ToolParam(description = "设备类型ID")String typeId,
//	                      @ToolParam(description = "移动的距离,范围是0-100")int progress){
//		log.info("mcp调用--->根据主机号和设备ID控制其移动位置....ccuName:{},devId:{},type:{},progress:{}",ccuName,devId,typeId,progress);
//		return konkeIotServer.setMove(CcuUtils.getCcuName(ccuName), devId, typeId,progress);
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID控制设备:延时关机.只支持新风、地暖、空调")
//	public String setDelayedShutdown(@ToolParam(description = "主机号")String ccuName,
//	                      @ToolParam(description = "设备ID")String devId,
//	                      @ToolParam(description = "设备类型ID")String typeId,
//	                      @ToolParam(description = "多少分钟后关机,范围30-1440,必须是30的倍数,最小是半小时")int delayTime){
//		log.info("mcp调用--->根据主机号和设备ID控制设备延时关机....ccuName:{},devId:{},type:{},delayTime:{}",ccuName,devId,typeId,delayTime);
//		return konkeIotServer.setDelayedShutdown(CcuUtils.getCcuName(ccuName), devId, typeId,delayTime);
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作温度.只支持空调、地暖")
//	public String setTemperature(@ToolParam(description = "主机号")String ccuName,
//	                                 @ToolParam(description = "设备ID")String devId,
//	                                 @ToolParam(description = "设备类型ID")String typeId,
//	                                 @ToolParam(description = "设置的温度大小,范围是5-35")double temperature){
//		log.info("mcp调用--->根据主机号和设备ID设置设备的工作温度....ccuName:{},devId:{},type:{},temperature:{}",ccuName,devId,typeId,temperature);
//		return konkeIotServer.setTemperature(CcuUtils.getCcuName(ccuName), devId, typeId,temperature);
//	}
//	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作模式.只支持地暖、空调、新风")
//	public String setModel(@ToolParam(description = "主机号")String ccuName,
//	                             @ToolParam(description = "设备ID")String devId,
//	                             @ToolParam(description = "设备类型ID")String typeId,
//	                             @ToolParam(description = "设置的工作模式,枚举值:WIND、HOT、COLD、DEHUMIDIFICATION、AUTO、MANUAL")String mode){
//		log.info("mcp调用--->根据主机号和设备ID设置设备的工作模式....ccuName:{},devId:{},type:{},mode:{}",ccuName,devId,typeId,mode);
//		return konkeIotServer.setModel(CcuUtils.getCcuName(ccuName), devId, typeId,mode);
//	}
//
//	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作风速.只支持空调、新风")
//	public String setSpeed(@ToolParam(description = "主机号")String ccuName,
//	                       @ToolParam(description = "设备ID")String devId,
//	                       @ToolParam(description = "设备类型ID")String typeId,
//	                       @ToolParam(description = "设置的工作风速,枚举值:LOW、MID、HIGH、AUTO、STOP")String speed){
//		log.info("mcp调用--->根据主机号和设备ID设置设备的工作风速....ccuName:{},devId:{},type:{},mode:{}",ccuName,devId,typeId,speed);
//		return konkeIotServer.setSpeed(CcuUtils.getCcuName(ccuName), devId, typeId,speed);
//	}
//
//
//
//	@Tool(description = "智能家居相关：根据主机号和场景ID:触发场景")
//	public String triggerScene(@ToolParam(description = "主机号")String ccuName,
//	                              @ToolParam(description = "场景ID")String devId,
//	                              @ToolParam(description = "场景类型ID,type等于scene")String typeId){
//		log.info("mcp调用--->根据主机号和场景ID触发场景....ccuName:{},devId:{},type:{}",ccuName,devId,typeId);
//		return konkeIotServer.optScene(CcuUtils.getCcuName(ccuName), devId);
//	}
//
//	//===================================================================================================
//
//
//}
