package com.ikonke.konkeaialibabamcp.aitools;

import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

/**
 * 访客相关
 */
@Slf4j
@Service
public class CDCVisitorTools {

	@Tool(description = "社区访客相关：访客预约")
	public String visitorAppointments(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
			@ToolParam(description = "访客姓名,如：张三")String name,
			@ToolParam(description = "访客的车牌号,如：沪BDF1234")String cartNumber,
			@ToolParam(description = "访客上门的时间,如：2025-08-12")String date){
		log.info("【{}】mcp调用--->访客相关：访客预约,cartNumber:{},时间：{}",sn,cartNumber,date);
		return "已为访客 "+name+" 的车牌号 "+cartNumber+" 在 "+date+" 预约成功";
	}
}
