package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.constant.DeviceConstant;
import com.ikonke.konkeaialibabamcp.constant.RedisKeys;
import com.ikonke.konkeaialibabamcp.controller.param.AddSceneParam;
import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
import com.ikonke.konkeaialibabamcp.entity.mysql.DeviceModel;
import com.ikonke.konkeaialibabamcp.entity.mysql.SynDevice;
import com.ikonke.konkeaialibabamcp.entity.mysql.TemporaryScene;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ISynDeviceService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ITemporarySceneService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.awt.*;
import java.time.LocalDateTime;
import java.util.*;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class KonkeIotUtils {



	@Value("${konke.deviceCloud.baseUrl}")
	private String baseUrl;
	@Value("${konke.deviceCloud.appId}")
	private String appId;

	@Value("${konke.deviceCloud.appKey}")
	private String appKey;

	private final MongoTemplate mongoTemplate;
	private final SycDeviceService sycDeviceService;
	private final ITemporarySceneService temporarySceneService;

	public KonkeIotUtils(MongoTemplate mongoTemplate, SycDeviceService sycDeviceService, ITemporarySceneService temporarySceneService) {
		this.mongoTemplate = mongoTemplate;
		this.sycDeviceService = sycDeviceService;
		this.temporarySceneService = temporarySceneService;
	}

	public final static Map<String, String> actionMap = Map.of(
			"3", "SwitchOpt"
	);


	/**
	 * 判断设备是否在线
	 */
	public boolean getDeviceOnline(String ccuName, String devId){
		DeviceStatus one = mongoTemplate.findOne(Query.query(
				Criteria.where("ccuName").is(ccuName)
						.and("devId").is(devId)
		), DeviceStatus.class);

		return one != null && one.getStatus().containsKey("online") && "1".equals(one.getStatus().get("online").toString());
	}

	public String batchOptDeviceOpen(String ccuName, String devIds){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));

			// 异步执行设备操作，不阻塞主线程
//			CompletableFuture.runAsync(() -> {
//				try {
//					for(String devId : devIdList){
//						if (getDeviceOnline(ccuName, devId)) {
//							log.warn("设备已离线: {}", devId);
//							continue;
//						}
//						SynDevice byId = sycDeviceService.findById(ccuName, devId);
//						if(byId==null){
//							continue;
//						}
//						this.optDeviceOpen(ccuName,devId,byId.getOperateId());
//					}
//					log.info("批量开启设备操作完成");
//				} catch (Exception e) {
//					log.error("异步执行设备开启操作失败", e);
//				}
//			});

			// 异步执行？
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.optDeviceOpen(ccuName,devId,byId.getOperateId());
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	public String optDeviceOpen(String ccuName, String devId,String operateId){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("SwitchOpt")){
			action = "SwitchOpt";
		}else if(list.contains("MotorOpt")){
			action = "MotorOpt";
		}else if(list.contains("FreshAirSwitch")){
			action = "FreshAirSwitch";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("SwitchOpt".equals(action)){
			opt.set("on", true);
		}else if("MotorOpt".equals(action)){
			opt.set("opt", "OPEN");
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchOptDeviceClosed(String ccuName, String devIds){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.optDeviceClosed(ccuName,devId,byId.getOperateId());
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}
	public String optDeviceClosed(String ccuName, String devId,String operateId){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("SwitchOpt")){
			action = "SwitchOpt";
		}else if(list.contains("MotorOpt")){
			action = "MotorOpt";
		}else if(list.contains("FreshAirSwitch")){
			action = "FreshAirSwitch";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}

		JSONObject opt = new JSONObject();
		if("SwitchOpt".equals(action)){
			opt.set("on", false);
		}else if("MotorOpt".equals(action)){
			opt.set("opt", "CLOSE");
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}

		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetBrightness(String ccuName, String devIds,int brightness){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setBrightness(ccuName,devId,byId.getOperateId(), brightness);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 设置亮度
	 */
	public String setBrightness(String ccuName, String devId,String operateId,int brightness){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || brightness < 0 || brightness > 100){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("DimmerAdjustLuminance")){
			action = "DimmerAdjustLuminance";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("DimmerAdjustLuminance".equals(action)){
			opt.set("progress", brightness);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}

		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetColourTemperature(String ccuName, String devIds,int colourTemperature){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setColourTemperature(ccuName,devId,byId.getOperateId(), colourTemperature);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 设置色温
	 */
	public String setColourTemperature(String ccuName, String devId,String operateId,int colourTemperature){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || colourTemperature < 0 || colourTemperature > 100){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("AdjustColourTemperature")){
			action = "AdjustColourTemperature";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("AdjustColourTemperature".equals(action)){
			opt.set("progress", colourTemperature);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}

		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetColor(String ccuName, String devIds,String color){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setColor(ccuName,devId,byId.getOperateId(), color);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}
	/**
	 * 设置颜色
	 */
	public String setColor(String ccuName, String devId,String operateId,String color){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}

		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("DimmerAdjustColor")){
			action = "DimmerAdjustColor";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("DimmerAdjustColor".equals(action)){
			Color c = ColorUtil.getColor(StrUtil.upperFirst(color.toLowerCase()));
			int [] rgb = {c.getRed(),c.getGreen(),c.getBlue()};
			opt.set("rgb", rgb);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}

		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetPause(String ccuName, String devIds){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setPause(ccuName,devId, byId.getOperateId());
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 暂停-目前只有窗帘才支持暂停
	 */
	public String setPause(String ccuName, String devId,String operateId){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("MotorOpt")){
			action = "MotorOpt";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("MotorOpt".equals(action)){
			opt.set("opt", "STOP");
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetMove(String ccuName, String devIds,int progress){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setMove(ccuName,devId, byId.getOperateId(), progress);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}
	/**
	 * 移动位置-目前只有窗帘电机才支持移动位置
	 */
	public String setMove(String ccuName, String devId,String operateId,int progress){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || (progress<0 || progress>100)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		if(progress<0 || progress>100){
			throw new StatefulException(-31, "移动的位置只能是0到100");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("DooyaMotorSeek")){
			action = "DooyaMotorSeek";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("DooyaMotorSeek".equals(action)){
			opt.set("progress", progress);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetDelayedShutdown(String ccuName, String devIds,int delayTime){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setDelayedShutdown(ccuName,devId, byId.getOperateId(), delayTime);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 设置延时关机
	 * delayTime:分钟 最多24小时
	 */
	public String setDelayedShutdown(String ccuName, String devId,String operateId,int delayTime){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || (delayTime<0 || delayTime>24*60)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if(delayTime % 30 != 0){
			throw new StatefulException(-31, "延时时间只能是30的倍数");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		if(delayTime<0 || delayTime>24*60){
			throw new StatefulException(-31, "延时时间在0-24小时之间");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("FancoilSetDelaytask")){
			action = "FancoilSetDelaytask";
		}else if(list.contains("SetFloorheatingOffTime")){
			action = "SetFloorheatingOffTime";
		}else if(list.contains("SetChopinFreshAirTimeOff")){
			action = "SetChopinFreshAirTimeOff";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("FancoilSetDelaytask".equals(action)){
			opt.set("onEnable", false);
			opt.set("onDelayTime", "00:00");
			opt.set("offEnable", true);
			opt.set("offDelayTime", convertMinutesToTime(delayTime));
		}else if("SetFloorheatingOffTime".equals(action)){
			opt.set("offTime", convertMinutesToTime(delayTime));
		}else if("SetChopinFreshAirTimeOff".equals(action)){
			opt.set("timeOff", convertMinutesToTime(delayTime));
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	/**
	 * 将分钟数转换为 HH:mm 格式的时间字符串
	 *
	 * @param minutes 分钟数，范围 0-1440
	 * @return 格式化的时间字符串，如 "00:30", "01:00", "24:00"
	 * @throws IllegalArgumentException 如果分钟数不在 0-1440 范围内
	 */
	public static String convertMinutesToTime(int minutes) {
		// 验证输入范围
		if (minutes < 0 || minutes > 1440) {
			throw new IllegalArgumentException("分钟数必须在 0-1440 范围内");
		}
		// 计算小时和分钟
		int hours = minutes / 60;
		int mins = minutes % 60;

		// 格式化为 HH:mm 字符串
		return String.format("%02d:%02d", hours, mins);
	}

	public String batchSetTemperature(String ccuName, String devIds,double temperature){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setTemperature(ccuName,devId, byId.getOperateId(), temperature);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 设置温度
	 */
	public String setTemperature(String ccuName, String devId,String operateId,double temperature){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || (temperature<0 || temperature>35)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		if(temperature<5 || temperature>35){
			throw new StatefulException(-31, "温度范围在5到35之间");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("FancoilSetRunTemp")){
			action = "FancoilSetRunTemp";
		}else if(list.contains("SetFloorheatingWorkTemperature")){
			action = "SetFloorheatingWorkTemperature";
		}

		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("FancoilSetRunTemp".equals(action)){
			opt.set("runTemp", temperature);
		}else if("SetFloorheatingWorkTemperature".equals(action)){
			opt.set("temparature", temperature);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}


	public String batchSetModel(String ccuName, String devIds,String mode){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setModel(ccuName,devId, byId.getOperateId(), mode);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 * 设置模式
	 */
	public String setModel(String ccuName, String devId,String operateId,String mode){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || StrUtil.isBlank(mode)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("FancoilSetRunModel")){
			action = "FancoilSetRunModel";
		}else if(list.contains("SetFloorheatingWorkMode")){
			action = "SetFloorheatingWorkMode";
		}else if(list.contains("FreshAirSetRunModel")){
			action = "FreshAirSetRunModel";
		}

		switch (operateId) {
			case "15005"://空调
				if(!DeviceConstant.mode_15005.contains(mode)){
					throw new StatefulException(-32, "不支持的模式");
				}
				break;
			case "12505"://地暖
				if(!DeviceConstant.mode_12505.contains(mode)){
					throw new StatefulException(-32, "不支持的模式");
				}
				break;
			case "14003"://新风
				if(!DeviceConstant.mode_12505.contains(mode)){
					throw new StatefulException(-32, "不支持的模式");
				}
				break;
			default:
				break;
		}
		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("FancoilSetRunModel".equals(action)){
			opt.set("runModel", mode);
		}else if("SetFloorheatingWorkMode".equals(action)){
			opt.set("runModel", mode);
		}else if("FreshAirSetRunModel".equals(action)){
			opt.set("runModel", mode);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}

	public String batchSetSpeed(String ccuName, String devIds,String speed){
		try {
			if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devIds)){
				throw new StatefulException(-20, "参数不能为空");
			}
			List<String> devIdList = List.of(devIds.split(","));
			for(String devId : devIdList){
				if (getDeviceOnline(ccuName, devId)) {
					throw new StatefulException(-30, "设备已离线");
				}
				SynDevice byId = sycDeviceService.findById(ccuName, devId);
				if(byId==null){
					continue;
				}
				this.setSpeed(ccuName,devId, byId.getOperateId(), speed);
			}

			return "控制成功";
		}catch (Exception e){
			e.printStackTrace();
			return "控制失败";
		}
	}

	/**
	 *  设置风速
	 */
	public String setSpeed(String ccuName, String devId,String operateId,String speed){
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(devId) || StrUtil.isBlank(operateId) || StrUtil.isBlank(speed)){
			throw new StatefulException(-20, "参数不能为空");
		}
		if (getDeviceOnline(ccuName, devId)) {
			throw new StatefulException(-30, "设备已离线");
		}
		String action = null;

		DeviceModel deviceModel = sycDeviceService.getDeviceModel(Integer.valueOf(operateId));
		List<String> list = Arrays.asList(deviceModel.getActions().split(","));
		if(list.contains("FancoilSetFanSpeed")){
			action = "FancoilSetFanSpeed";
		}else if(list.contains("FreshAirSetSpeed")){
			action = "FreshAirSetSpeed";
		}

		switch (operateId) {
			case "15005"://空调
				if(!DeviceConstant.speed_15005.contains(speed)){
					throw new StatefulException(-32, "不支持的风速");
				}
				break;
			case "14003"://新风
				if(!DeviceConstant.speed_12505.contains(speed)){
					throw new StatefulException(-32, "不支持的风速");
				}
				break;
			default:
				break;
		}
		if(action == null){
			throw new StatefulException(-20, "暂不支持该操作");
		}
		JSONObject opt = new JSONObject();
		if("FancoilSetFanSpeed".equals(action)){
			opt.set("speed", speed);
		}else if("FreshAirSetSpeed".equals(action)){
			opt.set("speed", speed);
		}else{
			throw new StatefulException(-20, "暂不支持该操作");
		}
		return optAIDevice(ccuName, devId, action,opt.toString());
	}


	// 如何控制设备
	/**
	 * 1、查找设备是否存在
	 * 2、根据设备ID查询设备状态（判断是否已操作符合，比如已经开灯了）？？？
	 * 3、设备支持哪些操作？
	 * 4、根据设备ID操作设备
	 */
	public String optAIDevice(String ccuName, String devId, String action, String actionArg){
		log.info("optAIDevice....ccuName:{},devId:{},action:{},actionArg:{}",ccuName,devId,action, JSONUtil.parseObj(actionArg));
		JSONObject opt = new JSONObject();
		opt.set("action", action);
		opt.set("actionArg", JSONUtil.parseObj(actionArg));

		return optDevice(ccuName, devId, opt.toString());
	}

	/**
	 * 触发场景
	 */
	public String optScene(String ccuName, String sceneId){
		if(StrUtil.isBlank(sceneId)){
			throw new StatefulException(-21, "场景不存在");
		}
		if(StrUtil.isBlank(ccuName) || StrUtil.isBlank(sceneId)){
			throw new StatefulException(-20, "参数错误");
		}
		String url = baseUrl + "/1.0/app/ccu/" + ccuName + "/dev/" + sceneId + "/opt";
		log.info("KonkeIotServer optScene url {}, param {}, appId {}, appKey {}", url, "", appId, appKey);
		JSONObject opt = new JSONObject();
		opt.set("action", "SceneExecute");
		String result2 = HttpRequest.post(url)
				.header("appId", appId)
				.header("appKey", appKey)
				.body(opt.toString())
				.execute().body();
		log.info("KonkeIotServer optScene result {}", result2);
		JSONObject jsonObject = JSONUtil.parseObj(result2);

		if(jsonObject.getBool("success")){
			return "触发场景成功";
		}else{
			return "触发场景失败";
		}
	}

	/**
	 * 获取场景
	 */
	public String getScene(String ccuName, String sceneId){
		String url = baseUrl + "/2.0/ccu/" + ccuName + "/scenes?actions=true&id="+sceneId;
		log.info("KonkeIotServer getScene url {}, ccuName {},sceneId:{}", url, ccuName,sceneId);
		String body = HttpRequest.get(url)
				.header("appId", appId)
				.header("appKey", appKey)
				.timeout(20000)
				.execute().body();
		JSONObject json_response = JSONUtil.parseObj(body);
		if(json_response.getBool("success")){
			JSONArray data = json_response.getJSONArray("data");
			JSONObject data_json = data.getJSONObject(0);
			return data_json.toString();
		}else{
			throw new StatefulException(-20, "获取场景失败");
		}
	}

	/**
	 *  删除场景
	 */
	public Boolean delScene(String sn,String ccuName, String sceneId){
		if(StrUtil.isBlank(sn) || StrUtil.isBlank(ccuName) || StrUtil.isBlank(sceneId)){
			return false;
		}
		log.info("delScene..删除场景..sn:{},ccuName:{},sceneId:{}",sn,ccuName,sceneId);

		QueryWrapper<TemporaryScene> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);
		wrapper.eq("temporarySceneId", sceneId);
		List<TemporaryScene> list = temporarySceneService.list(wrapper);
		if(list.isEmpty()){
			return true;
		}else{
			for(TemporaryScene scene : list){
				temporarySceneService.removeById(scene.getId());
			}
		}


		String url = baseUrl + "/2.0/ccu/" + ccuName + "/scene/" + sceneId;
		String body = HttpRequest.delete(url)
				.header("appId", appId)
				.header("appKey", appKey)
				.execute().body();
		return JSONUtil.parseObj(body).getBool("success");
	}

	/**
	 * POST 'https://iot.ikonke.com:4432/2.0/ccu/CCU_00001/scenes'
	 * {
	 *     "name": "场景名称",
	 *     "roomId": 2,
	 *     "actions": [
	 *         {
	 *             "id": -1,
	 *             "realType": "ALL_LIGHT",
	 *             "roomId": 4,
	 *             "delay": 1,
	 *             "operation": "ON",
	 *             "name": "全部灯光"
	 *         }
	 *     ]
	 * }
	 *
	 * 1、验证参数
	 * 2、保存场景
	 * 3、返回场景ID
	 * 4、返回场景getScene
	 *
	 * 5、这个场景应该是一个临时场景,若用户没有说保存，应该删除掉
	 */
	public String addScene(String sn,String ccuName,JSONObject scene){
		try {
			AddSceneParam bean = JSONUtil.toBean(scene, AddSceneParam.class);

			JSONObject body = new JSONObject();
			body.set("name", bean.getName());
			body.set("roomId", bean.getRoomId());

			JSONArray actions = new JSONArray();
			for (AddSceneParam.SceneAction action : bean.getActions()) {
				JSONObject body_action = new JSONObject();
				body_action.set("id", action.getDevId());
				body_action.set("realType",sycDeviceService.getDeviceRealType(Integer.valueOf(action.getTypeId())));
				body_action.set("delay", 0);
				body_action.set("operation", this.getSceneAction(action.getOperation()));

				actions.set(body_action);
			}

			body.set("actions", actions);

			String url = baseUrl + "/2.0/ccu/" + ccuName + "/scenes";
			log.info("addScene..新增场景..url:{},body:{}",url,body.toString());
			String result = HttpRequest.post(url)
					.header("appId", appId)
					.header("appKey", appKey)
					.body(body.toString())
					.execute().body();

			log.info("addScene..新增场景..result:{}",result);
			JSONObject response = JSONUtil.parseObj(result);
			if(!response.getBool("success")){
				throw new StatefulException(-1, response.getStr("message"));
			}else{
				Integer scene_id = response.getInt("data");


				TemporaryScene temporaryScene = new TemporaryScene();
				temporaryScene.setCcuId(ccuName);
				temporaryScene.setTemporarySceneId(scene_id+"");
				temporaryScene.setCreateTime(LocalDateTime.now());
				temporarySceneService.save(temporaryScene);


				log.info("addScene..新增场景..result:{}",scene_id);
				return scene_id+"";
			}
		}catch (Exception e){
			e.printStackTrace();
			throw new StatefulException(-20, "新增临时场景失败");
		}
	}

	/**
	 * 保存临时场景
	 */
	public Boolean saveTemporaryScene(String ccuName,String temporarySceneId){
		try {
			QueryWrapper<TemporaryScene> wrapper = new QueryWrapper<>();
			wrapper.eq("ccuId", ccuName);
			wrapper.eq("temporarySceneId", temporarySceneId);
			List<TemporaryScene> list = temporarySceneService.list(wrapper);
			if(!list.isEmpty()){
				for(TemporaryScene scene : list){
					temporarySceneService.removeById(scene.getId());
				}
			}
			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * 将大模型推荐的action转换成新增场景的action
	 *
	 */
	public Object getSceneAction(Map<String, Object> operation){
		if(operation.size()==1){
			Map.Entry<String, Object> firstEntry = operation.entrySet().iterator().next();
			String firstKey = firstEntry.getKey();
			Object firstValue = firstEntry.getValue();

			if("on".equalsIgnoreCase(firstKey)){
				if("false".equalsIgnoreCase(firstValue.toString())){
					return "OFF";
				}else if("true".equalsIgnoreCase(firstValue.toString())){
					return "ON";
				}else if("STOP".equalsIgnoreCase(firstValue.toString())){
					return "STOP";
				}else if("CLOSE".equalsIgnoreCase(firstValue.toString())){
					return "CLOSE";
				}else if("OPEN".equalsIgnoreCase(firstValue.toString())){
					return "OPEN";
				}else{
					return firstValue;
				}
			}else{
				log.error("不支持的操作1:{}",JSONUtil.toJsonStr(operation));
			}
		}else{
			JSONObject jsonObject = new JSONObject();
			for (String key : operation.keySet()){
				if("bri".equalsIgnoreCase(key)){
					jsonObject.set("bri", operation.get(key));
				}else if("on".equalsIgnoreCase(key)){
					jsonObject.set("on", operation.get(key));
				}else if("colour_temperature".equalsIgnoreCase(key)){
					jsonObject.set("colour_temperature", operation.get(key));
				}else if("move_to_angle".equalsIgnoreCase(key)){
					jsonObject.set("move_to_angle", operation.get(key));
				} else if("move_to_pos".equalsIgnoreCase(key)){
					jsonObject.set("move_to_pos", operation.get(key));
				}else if("white_bri".equalsIgnoreCase(key)){
					jsonObject.set("white_bri", operation.get(key));
				}else if("rgb".equalsIgnoreCase(key)){
					Color c = ColorUtil.getColor((String) operation.get(key));
					int [] rgb = {c.getRed(),c.getGreen(),c.getBlue()};
					jsonObject.set("rgb", rgb);
				}else if("speed".equalsIgnoreCase(key)){
					jsonObject.set("speed", operation.get(key));
				}else if("runModel".equalsIgnoreCase(key)){
					jsonObject.set("runModel", operation.get(key));
					jsonObject.set("mode", operation.get(key));
				}else if("runTemp".equalsIgnoreCase(key)){
					jsonObject.set("runTemp", operation.get(key));
					jsonObject.set("setTemp", operation.get(key));
					jsonObject.set("temp", operation.get(key));
				}else{
					log.error("不支持的操作2:{}",JSONUtil.toJsonStr(operation));
				}
			}

			return jsonObject;
		}
		return null;
	}

	/**
	 * {"action":"SwitchOpt","actionArg":{"on":true}}
	 */
	public String optDevice(String ccuName, String devId, String requestMessage){
		String url = baseUrl + "/1.0/app/ccu/" + ccuName + "/dev/" + devId + "/opt";
		log.info("KonkeIotServer optDevice url {}, param {}, appId {}, appKey {}", url, requestMessage, appId, appKey);
		String result2 = HttpRequest.post(url)
				.header("appId", appId)
				.header("appKey", appKey)
				.body(requestMessage)
				.execute().body();
		log.info("KonkeIotServer optDevice result {}", result2);
		return result2;
	}
}
