package com.ikonke.konkeaialibabamcp.controller;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.constant.RedisKeys;
import com.ikonke.konkeaialibabamcp.controller.param.DifyStreamResponse;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import jakarta.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/dify")
public class DifyController {

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private WebClient webClient;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${cdc.difyChatSteamMessages}")
	private String difyChatSteamMessages;

	private String dify_api_key;

	@PostConstruct
	public void init() {
		Object redisValue = redisTemplate.opsForValue().get(RedisKeys.KONKE_DIFY_API_KEY);

		// 如果Redis中有值，则使用Redis中的值覆盖配置文件的值
		if (redisValue != null) {
			this.dify_api_key = redisValue.toString();
			log.info("Using Dify API key from Redis: {}", this.dify_api_key);
		} else {
			log.info("Using Dify API key from configuration file: {}", this.dify_api_key);
		}
	}

//	/**
//	 * 思必驰 demo
//	 * https://www.duiopen.com/docs/ct_dsk_protocol
//	 *
//	 */
//	@RequestMapping(value = "/demo", method = RequestMethod.POST, consumes = "application/json")
//	@ResponseBody
//	public JSONObject demo(@RequestBody JSONObject jsonObject) {
//		Long timestamp = System.currentTimeMillis();
//		log.info("思必驰 demo..请求参数:{}",jsonObject.toString());
//		JSONObject result = jsonObject.getJSONObject("request");
//		JSONObject context = jsonObject.getJSONObject("context");
//		JSONObject device = context.getJSONObject("device");
//		String deviceName = device.getStr("deviceName");
//
//		String type = result.get("type").toString();
//		String input;  //请求文本
//		String res = "{'version': '1.0','response': {'speak': {'type': 'text','text': '%s','ssml': 'SSML markup text string to speak'}},'shouldEndSession': %b}"; //忽略了部分DSK协议字段,shouldEndSession字段决定是否结束本轮对话
//
//
//		JSONObject response = JSONUtil.parseObj(String.format(res, "error", true));  // 响应报文
//		JSONArray slots;
//		String ai_result = "";
//		try {
//			slots = result.getJSONArray("inputs");
//			input = slots.getJSONObject(0).get("input").toString();
//
////			if (type.equals("start")) {  //唤醒
////				res = String.format(res, "已唤醒", false);
////				log.info("新一轮对话开始...........");
////
////				response = JSONUtil.parseObj(res);
////			} else {  //继续对话
////				if (input.equals("helloworld") || input.equals("你好世界") || input.equals("世界你好")) { //根据关键词返回内容
////					res = String.format(res, String.format("这是第%d次helloworld", 2), false);
////				} else if (input.equals("再见") || type.equals("end")) { //结束对话,退出说法可以根据产品自行设定
////					res = String.format(res, "结束对话", true);
////				} else {
////					res = String.format(res, "我听不懂你在说什么", false);
////				}
////				response = JSONUtil.parseObj(res);
////			}
//			if (type.equals("start")) {
//				log.info("新一轮对话开始...........");
//			}
//
//			//根据userId获取到对应的主机号等信息
//			QueryWrapper<CDCToken> wrapper = new QueryWrapper<>();
//			wrapper.eq("aiSpeechUserId", deviceName);
//			List<CDCToken> list = tokenService.list(wrapper);
//			if(list.size() == 1){
//				CDCToken token = list.get(0);
//
//				String url = difyChatSteamMessages + "/dify/chatSteamMessages?query="+input;
//				log.info("开始 dify 请求:{}",url);
//				ai_result = HttpRequest.get(url)
//						.header("ccuName", token.getCcuId() )
//						.header("token", token.getAccessToken())
//						.header("sn",token.getSn())
//						.timeout(600000)
//						.execute().body();
//
//				log.info("dify请求返回:{}",ai_result);
//
//				String result_end = ai_result.replaceAll("(?m)^\\s*$[\r\n]*", "").replaceAll("[\r\n]+", "\n").replaceAll("[\r\n]", "").trim();
//				log.info("dify请求返回2--->:{}",result_end);
//
//				res = String.format(res, result_end, false);
//				response = JSONUtil.parseObj(res);
//			}else if(list.size() > 1){
//				log.error("获取CDCToken失败，CDCToken数量大于1");
//				res = String.format(res, "绑定异常", false);
//				response = JSONUtil.parseObj(res);
//			}else{
//				res = String.format(res, "未绑定主机绑定", false);
//				response = JSONUtil.parseObj(res);
//			}
//		} catch (Exception e) {
//			res = String.format(res, "服务器异常,稍后重试.", false);
//			response = JSONUtil.parseObj(res);
//			e.printStackTrace();
//		} finally {
//			log.info("思必驰 demo..响应时间="+(System.currentTimeMillis()-timestamp));
//			return response;
//		}
//	}

	@GetMapping("/chatMessages")
	public String chatMessages(@RequestParam(name = "query") String query,
	                           @RequestHeader("ccuName") String ccuName,
	                           @RequestHeader("sn") String sn,
	                           @RequestHeader("token") String token){
		log.info("开始对话 sn:{},ccuName:{}, query:{}",sn,ccuName,query);
		//workflows/run
		String url = "http://172.17.12.12:8088/v1/chat-messages";

		JSONObject inputs = new JSONObject();
		inputs.set("ccuName",ccuName);
		inputs.set("sn",sn);
		inputs.set("token",token);

		JSONObject body = new JSONObject();
		body.set("inputs",inputs);
		body.set("query",query);
		body.set("response_mode","blocking");//blocking 阻塞模式,streaming 流式模式
		body.set("user",sn);

		String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
		Object redis_conversationId =redisTemplate.opsForValue().get(redis_key);
		String conversationId = null;
		if(redis_conversationId!=null){
			conversationId = redis_conversationId.toString();
		}
		CDCToken bySn = null;
		if(StrUtil.isBlank(conversationId)){
			bySn = tokenService.findBySn(sn);
			if(bySn!=null && StrUtil.isNotBlank(bySn.getConversationId())){
				conversationId = bySn.getConversationId();
				body.set("conversation_id",conversationId);//一个user一个会话
			}
		}else{
			body.set("conversation_id",conversationId);
		}

		log.info("dify 普通对话 body:{}",body);

		String body1 = HttpRequest.post(url)
				.header("Authorization", "Bearer " + dify_api_key)
				.header("Content-Type", "application/json")
				.body(body.toString())
				.timeout(1000000)
				.execute().body();

		JSONObject jsonObject = new JSONObject(body1);

		if(redis_conversationId == null){//conversationId为null表示第一次对话
			conversationId = jsonObject.getStr("conversation_id");
			redisTemplate.opsForValue().set(redis_key, conversationId);
			bySn = tokenService.findBySn(sn);
			if(bySn!=null){
				bySn.setConversationId(conversationId);
				tokenService.updateById(bySn);
			}else{
				bySn = new CDCToken();
				bySn.setSn(sn);
				bySn.setCcuId(CcuUtils.getCcuName(ccuName));
				bySn.setAccessToken(token);
				bySn.setCreateTime(LocalDateTime.now());
				bySn.setState(CDCToken.STATE_ENABLED);
				bySn.setConversationId(conversationId);
				tokenService.save(bySn);
			}
		}

		return jsonObject.getStr("answer");
	}

	@GetMapping("/chatSteamMessages2")
	public Flux<String> chatSteamMessages2(@RequestParam(name = "query") String query,
	                                      @RequestParam("ccuName") String ccuName,
	                                      @RequestParam("sn") String sn,
	                                      @RequestParam("token") String token){
		log.info("开始 流式 对话 sn:{},ccuName:{}, query:{}",sn,ccuName,query);
		//workflows/run
		String url = "http://172.17.12.12:8088/v1/chat-messages";

		JSONObject inputs = new JSONObject();
		inputs.set("ccuName",ccuName);
		inputs.set("sn",sn);
		inputs.set("token",token);

		JSONObject body = new JSONObject();
		body.set("inputs",inputs);
		body.set("query",query);
		body.set("response_mode","streaming");//blocking 阻塞模式,streaming 流式模式
		body.set("user",sn);

		String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
		Object redis_conversationId =redisTemplate.opsForValue().get(redis_key);
		String conversationId = null;
		if(redis_conversationId!=null){
			conversationId = redis_conversationId.toString();
		}
		CDCToken bySn = null;
		if(StrUtil.isBlank(conversationId)){
			bySn = tokenService.findBySn(sn);
			if(bySn!=null && StrUtil.isNotBlank(bySn.getConversationId())){
				conversationId = bySn.getConversationId();
				body.set("conversation_id",conversationId);//一个user一个会话
			}
		}else{
			body.set("conversation_id",conversationId);
		}

		log.info("dify key:{} , 对话 body:{}",dify_api_key,body);


		return webClient.post()
				.uri(url)
				.headers(httpHeaders -> {
					httpHeaders.setContentType(MediaType.APPLICATION_JSON);
					httpHeaders.setBearerAuth(dify_api_key);
				})
				.bodyValue(body)
				.retrieve()
				.bodyToFlux(DifyStreamResponse.class)//实体转换
				.timeout(Duration.ofMinutes(1))//设置超时时间1分钟
				.filter(this::shouldInclude) // 过滤掉不需要的数据【根据需求增加】
				.map((DifyStreamResponse difyStreamResponse) -> convertToCustomResponseAsync(difyStreamResponse, sn, ccuName, token, redis_conversationId)) // 异步转换【如果返回格式自定义则通过异步转换实现】
				.onErrorResume(throwable -> {
					log.info("异常输出："+throwable.getMessage());
					return null;
				});
	}

	/**
	 * 停止响应
	 * 仅支持流式模式。
	 */
	@GetMapping("/stopChatSteamMessages")
	public String stopChatSteamMessages(@RequestHeader("sn") String sn){
		log.info("结束 流式 对话, sn = {}",sn);
		String redis_task_key =  RedisKeys.KONKE_DIFY_LAST_STEAM_CHAT_TASK_ID+ sn;
		Object redis_task_id =redisTemplate.opsForValue().get(redis_task_key);
		if(redis_task_id!=null){
			String url = "http://172.17.12.12:8088/chat-messages/"+redis_task_id+"/stop";
			JSONObject body = new JSONObject();
			body.set("user",sn);
			String body1 = HttpRequest.post(url)
					.header("Authorization", "Bearer " + dify_api_key)
					.header("Content-Type", "application/json")
					.body(body.toString())
					.timeout(1000000)
					.execute().body();
			return body1;
		}
		return "{\"result\": \"error\"}";
	}
	@GetMapping("/chatSteamMessages")
	public Flux<String> chatSteamMessages(@RequestParam(name = "query") String query,
	                           @RequestHeader("ccuName") String ccuName,
	                           @RequestHeader("sn") String sn,
	                           @RequestHeader("token") String token){
		log.info("开始 流式 对话 sn:{},ccuName:{}, query:{}",sn,ccuName,query);
		//workflows/run
		String url = "http://172.17.12.12:8088/v1/chat-messages";

		JSONObject inputs = new JSONObject();
		inputs.set("ccuName",ccuName);
		inputs.set("sn",sn);
		inputs.set("token",token);

		JSONObject body = new JSONObject();
		body.set("inputs",inputs);
		body.set("query",query);
		body.set("response_mode","streaming");//blocking 阻塞模式,streaming 流式模式
		body.set("user",sn);

		String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
		Object redis_conversationId =redisTemplate.opsForValue().get(redis_key);
		String conversationId = null;
		if(redis_conversationId!=null){
			conversationId = redis_conversationId.toString();
		}
		CDCToken bySn = null;
		if(StrUtil.isBlank(conversationId)){
			bySn = tokenService.findBySn(sn);
			if(bySn!=null && StrUtil.isNotBlank(bySn.getConversationId())){
				conversationId = bySn.getConversationId();
				body.set("conversation_id",conversationId);//一个user一个会话
			}
		}else{
			body.set("conversation_id",conversationId);
		}

		log.info("dify key:{} ,流式 对话 body:{}",dify_api_key,body);


		return webClient.post()
				.uri(url)
				.headers(httpHeaders -> {
					httpHeaders.setContentType(MediaType.APPLICATION_JSON);
					httpHeaders.setBearerAuth(dify_api_key);
				})
				.bodyValue(body)
				.retrieve()
				.bodyToFlux(DifyStreamResponse.class)//实体转换
				.timeout(Duration.ofMinutes(1))//设置超时时间1分钟
                .filter(this::shouldInclude) // 过滤掉不需要的数据【根据需求增加】
				.map((DifyStreamResponse difyStreamResponse) -> convertToCustomResponseAsync(difyStreamResponse, sn, ccuName, token, redis_conversationId)) // 异步转换【如果返回格式自定义则通过异步转换实现】
				.onErrorResume(throwable -> {
					log.info("异常输出："+throwable.getMessage());
					return null;
				});
	}

	private String convertToCustomResponseAsync(DifyStreamResponse difyStreamResponse,String sn,String ccuName,String token,Object redis_conversationId) {
		if(redis_conversationId == null && StrUtil.isNotBlank(difyStreamResponse.getConversation_id())){//conversationId为null表示第一次对话
			// 保存最后一次对话的task_id，后续可暂停对话
			String redis_task_key =  RedisKeys.KONKE_DIFY_LAST_STEAM_CHAT_TASK_ID+ sn;
			redisTemplate.opsForValue().set(redis_task_key, difyStreamResponse.getTask_id());

			// 保存conversationId
			String conversationId = difyStreamResponse.getConversation_id();
			String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
			redisTemplate.opsForValue().set(redis_key, conversationId);

			CDCToken bySn = tokenService.findBySn(sn);
			if(bySn!=null){
				bySn.setConversationId(conversationId);
				tokenService.updateById(bySn);
			}else{
				bySn = new CDCToken();
				bySn.setSn(sn);
				bySn.setCcuId(CcuUtils.getCcuName(ccuName));
				bySn.setAccessToken(token);
				bySn.setCreateTime(LocalDateTime.now());
				bySn.setState(CDCToken.STATE_ENABLED);
				bySn.setConversationId(conversationId);
				tokenService.save(bySn);
			}
		}


		String answer = difyStreamResponse.getAnswer();
		if(StrUtil.isBlank(answer)){
			return "";
		}else{
			return answer;
		}
	}

	private boolean shouldInclude(DifyStreamResponse streamResponse) {
		// 示例：只要message节点的数据和message_end节点的数据
		if (streamResponse.getEvent().equals("message")
				|| streamResponse.getEvent().equals("message_end")) {
			return true;
		}
		return false;
	}


	@GetMapping("/getMessages")
	public JSONObject getMessages(@RequestParam(name = "limit") Integer limit,
	                           @RequestHeader("ccuName") String ccuName,
	                           @RequestHeader("sn") String sn,
	                           @RequestHeader("token") String token) {
		log.info("获取对话历史消息 sn:{},ccuName:{}, limit:{}", sn, ccuName, limit);


		String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
		Object redis_conversationId =redisTemplate.opsForValue().get(redis_key);
		String conversationId = null;
		if(redis_conversationId!=null){
			conversationId = redis_conversationId.toString();
		}
		if(StrUtil.isBlank(conversationId)){
			CDCToken bySn = tokenService.findBySn(sn);
			if(bySn!=null && StrUtil.isNotBlank(bySn.getConversationId())){
				conversationId = bySn.getConversationId();
			}
		}
		if(StrUtil.isBlank(conversationId)){
			return new JSONObject();
		}
		if(limit==null || limit <= 0){
			limit = 20;
		}
		String url = "http://172.17.12.12:8088/v1/messages?user="+sn+"&conversation_id="+conversationId+"&limit="+limit;
		log.info("dify 获取对话历史消息 url:{}",url);
		String body1 = HttpRequest.get(url)
				.header("Authorization", "Bearer " + dify_api_key)
				.header("Content-Type", "application/json")
				.timeout(1000000)
				.execute().body();
		JSONObject response = new JSONObject();
		JSONArray response_data = new JSONArray();

		JSONObject jsonObject = JSONUtil.parseObj(body1);
		Boolean has_more = jsonObject.getBool("has_more");
		if(jsonObject.containsKey("data") && jsonObject.get("data")!=null){
			JSONArray data = jsonObject.getJSONArray("data");
			for (int i = 0; i < data.size(); i++){
				JSONObject item = data.getJSONObject(i);
				String query = item.getStr("query");
				String answer = item.getStr("answer");

				JSONObject response_item = new JSONObject();
				response_item.set("query",query);
				response_item.set("answer",answer);
				response_item.set("created_at",item.get("created_at"));
				response_data.set(response_item);
			}
		}

		response.set("has_more",has_more);
		response.set("data",response_data);
		return response;
	}

}
