package com.ikonke.konkeaialibabamcp.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

@Configuration
@EnableAsync // 开启异步支持
public class AsyncConfig {

	// 配置线程池
	@Bean(name = "taskExecutor")
	public Executor taskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		// 核心线程数
		executor.setCorePoolSize(5);
		// 最大线程数
		executor.setMaxPoolSize(10);
		// 队列容量
		executor.setQueueCapacity(25);
		// 线程名称前缀
		executor.setThreadNamePrefix("Async-");
		// 当达到最大线程数时如何处理新任务
		executor.setRejectedExecutionHandler(new java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy());
		executor.initialize();
		return executor;
	}
}
