package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.core.date.DateUtil;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class CDCUtils {

	public static String[] time_segment = {
			"00:00-00:30","00:30-01:00","01:00-01:30","01:30-02:00","02:00-02:30",
			"02:30-03:00","03:00-03:30","03:30-04:00","04:00-04:30","04:30-05:00",
			"05:00-05:30","05:30-06:00","06:00-06:30","06:30-07:00","07:00-07:30",
			"07:30-08:00","08:00-08:30","08:30-09:00","09:00-09:30","09:30-10:00",
			"10:00-10:30","10:30-11:00","11:00-11:30","11:30-12:00","12:00-12:30",
			"12:30-13:00","13:00-13:30","13:30-14:00","14:00-14:30","14:30-15:00",
			"15:00-15:30","15:30-16:00","16:00-16:30","16:30-17:00", "17:00-17:30",
			"17:30-18:00","18:00-18:30","18:30-19:00","19:00-19:30","19:30-20:00",
			"20:00-20:30","20:30-21:00","21:00-21:30","21:30-22:00","22:00-22:30",
			"22:30-23:00", "23:00-23:30","23:30-24:00"};//前面包含，后面不包含

	/**
	 * 根据输入的时间（时分秒）找到在 time_segment 数组中的下标
	 *
	 * @param timeParam 输入的时间，格式为 "HH:mm:ss"，例如 "13:11:00"
	 * @return 对应的 time_segment 数组下标
	 */
	public static int getTimeSegmentIndex(String timeParam) {
		Date date3 = CDCUtils.roundToHalfHourOrHour(DateUtil.parse(timeParam));
		String time = DateUtil.formatTime(date3);

		// 提取小时和分钟部分
		String[] parts = time.split(":");
		int hour = Integer.parseInt(parts[0]);
		int minute = Integer.parseInt(parts[1]);

		// 计算从00:00开始的分钟数
		int totalMinutes = hour * 60 + minute;

		// 每个时间段是30分钟，计算所属时间段的索引
		int index = totalMinutes / 30;

		// 确保索引在有效范围内
		if (index >= 0 && index < time_segment.length) {
			return index;
		}

		// 如果超出范围，返回 -1 表示未找到
		return -1;
	}

	/**
	 * 将时间转换为半小时或整小时
	 * - 分钟小于30分钟的转换成30分钟
	 * - 分钟大于等于30分钟的小时加一，并将分钟设为0
	 *
	 * @param date 原始时间
	 * @return 转换后的时间
	 */
	public static Date roundToHalfHourOrHour(Date date) {
		LocalDateTime dateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
		int minute = dateTime.getMinute();
		int second = dateTime.getSecond();
		int nano = dateTime.getNano();
		// 如果已经是整点(0分0秒0纳秒)或半点(30分0秒0纳秒)，则不转换
		if ((minute == 0 || minute == 30) && second == 0 && nano == 0) {
			return date;
		}
		LocalDateTime roundedTime;
		if (minute < 30) {
			// 分钟小于30，设置为30分钟
			roundedTime = dateTime.withMinute(30).withSecond(0).withNano(0);
		} else {
			// 分钟大于等于30，进位到下一小时，分钟设为0
			roundedTime = dateTime.plusHours(1).withMinute(0).withSecond(0).withNano(0);
		}
		return Date.from(roundedTime.atZone(ZoneId.systemDefault()).toInstant());
	}

}
