package com.ikonke.konkeaialibabamcp.aitools;


import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.service.mongdbservice.DeviceStatusService;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import com.ikonke.konkeaialibabamcp.utils.WeatherUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class DeviceTools {

	private final DeviceStatusService deviceStatusUtil;
	private final KonkeIotUtils konkeIotServer;
	private final SycDeviceService sycDeviceService;
	private final WeatherUtils weatherUtils;
	public DeviceTools(DeviceStatusService deviceStatusUtil, KonkeIotUtils konkeIotServer, SycDeviceService sycDeviceService, WeatherUtils weatherUtils){
		this.deviceStatusUtil = deviceStatusUtil;
		this.konkeIotServer = konkeIotServer;
		this.sycDeviceService = sycDeviceService;
		this.weatherUtils = weatherUtils;
	}

	@Tool(description = "根据主机号和设备ID查询设备状态信息.")
	public DeviceStatus findDeviceState(@ToolParam(description = "主机号") String ccuName,
	                                    @ToolParam(description = "设备ID") Integer devId) {
		log.info("根据主机号和设备ID查询设备状态信息....ccuName:{},devId:{}",ccuName,devId);
		return deviceStatusUtil.findUserByUserId(ccuName, devId);
	}

	@Tool(description = "根据主机号和设备ID控制打开设备")
	public String optDeviceOpen(@ToolParam(description = "主机号")String ccuName,
	                        @ToolParam(description = "设备ID")String devId,
	                            @ToolParam(description = "设备类型")String operateId){
		log.info("根据主机号和设备ID控制打开设备....ccuName:{},devId:{},operateId:{}",ccuName,devId,operateId);
		return konkeIotServer.optDeviceOpen(ccuName, devId, operateId);
	}
	@Tool(description = "根据主机号和设备ID控制关闭设备")
	public String optDeviceClosed(@ToolParam(description = "主机号")String ccuName,
	                            @ToolParam(description = "设备ID")String devId,
	                            @ToolParam(description = "设备类型")String operateId){
		log.info("根据主机号和设备ID控制关闭设备....ccuName:{},devId:{},operateId:{}",ccuName,devId,operateId);
		return konkeIotServer.optDeviceClosed(ccuName, devId, operateId);
	}

	@Tool(description = "根据主机号同步设备")
	public boolean synchronousDevice(@ToolParam(description = "主机号")String ccuName){
		log.info("根据主机号同步设备....ccuName:{}",ccuName);
		return sycDeviceService.synchronousDevice(ccuName);
	}




	@Tool(description = "根据城市名查询当前的天气")
	public String getWeatherNow(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("根据城市名查询当前的天气....city:{}",city);
		return weatherUtils.getWeatherNow(city);
	}
	@Tool(description = "根据城市名查询未来24小时的天气")
	public String getWeatherHourly(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("根据城市名查询未来24小时的天气...city:{}",city);
		return weatherUtils.getWeatherHourly(city);
	}
	@Tool(description = "根据城市名查询未来7天的天气")
	public String getWeatherDaily(@ToolParam(description = "城市，如：成都、西安")String city){
		log.info("根据城市名查询未来7天的天气....city:{}",city);
		return weatherUtils.getWeatherDaily(city);
	}

}
