package com.ikonke.konkeaialibabamcp.utils;

import java.util.ArrayList;
import java.util.List;

public class TimeSlotMerger {
	public static class MergedSlot {
		private String start;
		private String end;
		private String available;

		public MergedSlot(String start, String end, String available) {
			this.start = start;
			this.end = end;
			this.available = available;
		}

		public String getStart() { return start; }
		public String getEnd() { return end; }
		public String getAvailable() { return available; }

		@Override
		public String toString() {
			return String.format("%s-%s: %s", start, end, available);
		}
	}

	/**
	 * 合并时间段的方法
	 * @param slots 包含48个元素的数组，每个元素为0或1
	 * @return 合并后的时间段列表
	 * @throws IllegalArgumentException 如果输入不符合要求
	 */
	public static List<MergedSlot> mergeTimeSlots(int[] slots) {
		// 验证输入
		if (slots == null || slots.length != 48) {
			throw new IllegalArgumentException("输入必须是包含48个元素的数组");
		}
//		for (int slot : slots) {
//			if (slot != 0 && slot != 1) {
//				throw new IllegalArgumentException("数组元素只能是0或1");
//			}
//		}

		List<MergedSlot> mergedSlots = new ArrayList<>();
		if (slots.length == 0) {
			return mergedSlots;
		}

		int currentStatus = slots[0];
		int startTimeIndex = 0;

		// 遍历所有时间段
		for (int i = 1; i < slots.length; i++) {
			if (slots[i] != currentStatus) {
				// 状态改变，记录上一个时间段
				mergedSlots.add(new MergedSlot(
						formatTime(startTimeIndex),
						formatTime(i),
						currentStatus == 1 ? "可预约" : "不可预约"
				));

				// 更新当前状态和开始索引
				currentStatus = slots[i];
				startTimeIndex = i;
			}
		}

		// 添加最后一个时间段
		mergedSlots.add(new MergedSlot(
				formatTime(startTimeIndex),
				formatTime(slots.length),
				currentStatus == 1 ? "可预约" : "不可预约"
		));

		return mergedSlots;
	}

	/**
	 * 将时间段索引转换为时间字符串
	 * @param index 时间段索引(0-48)
	 * @return 格式化的时间字符串，如"00:00"
	 */
	private static String formatTime(int index) {
		int hours = index / 2;
		int minutes = (index % 2) * 30;

		// 格式化小时和分钟为两位数
		return String.format("%02d:%02d", hours, minutes);
	}

	public static void main(String[] args) {
		int[] slots = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

		List<MergedSlot> merged = mergeTimeSlots(slots);

		// 输出结果
		for (MergedSlot slot : merged) {
			System.out.println(slot);
		}
	}
}
