package com.ikonke.konkeaialibabamcp.timedtasks;

import com.ikonke.konkeaialibabamcp.entity.mysql.TemporaryScene;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ITemporarySceneService;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;


@Slf4j
@Component
@EnableScheduling
public class TemporarySceneTask {

	@Autowired
	private ITemporarySceneService temporarySceneService;
	@Autowired
	private KonkeIotUtils konkeIotServer;
	@Autowired
	private ICDCTokenService cdcTokenService;

	/**
	 * 每5分钟、300秒 再执行一次该定时器。
	 */
	@Scheduled(fixedRate = 300000)
	public void task() {
		log.info("开始定时任务:删除数据库中的旧的临时任务");
		int i = temporarySceneService.delByCreateTime();

		List<TemporaryScene> temporaryScenes = temporarySceneService.queryOld();
		if(!temporaryScenes.isEmpty()){
			for(TemporaryScene scene : temporaryScenes){
				konkeIotServer.delScene("自动删除一小时以上的", scene.getCcuId(), scene.getTemporarySceneId());
			}
		}
		log.info("结束定时任务:删除数据库中的旧的临时任务数量"+i);
	}


	/**
	 * 每 43200 秒 、 720 分钟 、 12 小时 执行一次该定时器。
	 */
	@Scheduled(fixedRate = 43200000)
	public void examineCDCToken() {
		log.info("开始定时任务:检查建发的token是否过期");
		int i = cdcTokenService.examineCDCToken(1);
		log.info("结束定时任务:检查建发的token是否过期"+i);
	}


}
