package com.ikonke.konkeaialibabamcp.service;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.constant.DeviceConstant;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Device;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Region;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Room;
import com.ikonke.konkeaialibabamcp.entity.mongodb.Scene;
import com.ikonke.konkeaialibabamcp.entity.mysql.DeviceModel;
import com.ikonke.konkeaialibabamcp.entity.mysql.SynDevice;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.IDeviceModelService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ISynDeviceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
public class SycDeviceService {

	public static Cache<String, String> device_model_cache = CacheUtil.newLRUCache(1024);

	@Autowired
	private ISynDeviceService synDeviceService;
	@Autowired
	private MongoTemplate mongoTemplate;
	@Autowired
	private IDeviceModelService deviceModelService;

	public SynDevice findById(String ccuName,String deviceId){
		QueryWrapper<SynDevice> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);
		wrapper.eq("deviceId", deviceId);
		List<SynDevice> list = synDeviceService.list(wrapper);
		return list.isEmpty()?null:list.get(0);
	}

	public JSONArray findDeviceByName2(String ccuName,JSONArray param){
		long start = System.currentTimeMillis();
		JSONArray jsonArray = new JSONArray();
		if(StrUtil.isBlank(ccuName) || param.isEmpty()){
			return null;
		}
		QueryWrapper<SynDevice> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);

		wrapper.and(wrapper1 -> {
			// 处理第一个条件
			JSONObject first = param.getJSONObject(0);
			wrapper1.like("roomName", first.get("roomName"))
					.like("deviceName", first.get("deviceName"));

			// 处理剩余条件
			for (int i = 1; i < param.size(); i++) {
				JSONObject condition = param.getJSONObject(i);
				wrapper1.or()
						.like("roomName", condition.get("roomName"))
						.like("deviceName", condition.get("deviceName"));
			}
		});

		List<SynDevice> list = synDeviceService.list(wrapper);

		if(!list.isEmpty()){
			for (SynDevice synDevice : list) {
				JSONObject jsonObject = new JSONObject();
				String operateId = synDevice.getOperateId();
				jsonObject.set("deviceId", synDevice.getDeviceId());
				jsonObject.set("deviceName", synDevice.getDeviceName());
				jsonObject.set("roomId", synDevice.getRoomId());
				jsonObject.set("roomName", synDevice.getRoomName());
				jsonObject.set("typeId", operateId);
				jsonObject.set("model", synDevice.getModel());
				jsonArray.set(jsonObject);
			}
		}
		log.info("findDeviceByName..耗时:{}",System.currentTimeMillis()-start);
		return jsonArray;
	}

	public JSONArray findDeviceByName(String ccuName,String deviceName,String roomName){
		long start = System.currentTimeMillis();
		QueryWrapper<SynDevice> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);
		if(StrUtil.isNotBlank(roomName)){
			wrapper.like("roomName", roomName);
		}
		if(StrUtil.isNotBlank(deviceName)){
			wrapper.like("deviceName", deviceName);
		}
		List<SynDevice> list = synDeviceService.list(wrapper);
		JSONArray jsonArray = new JSONArray();
		if(!list.isEmpty()){
			for (SynDevice synDevice : list) {
				JSONObject jsonObject = new JSONObject();
				String operateId = synDevice.getOperateId();
				jsonObject.set("deviceId", synDevice.getDeviceId());
				jsonObject.set("deviceName", synDevice.getDeviceName());
				jsonObject.set("roomId", synDevice.getRoomId());
				jsonObject.set("roomName", synDevice.getRoomName());
				jsonObject.set("typeId", operateId);
				jsonObject.set("model", synDevice.getModel());
				jsonArray.set(jsonObject);
			}
		}
		log.info("findDeviceByName..耗时:{}",System.currentTimeMillis()-start);
		return jsonArray;
	}

	public JSONArray findByCcu(String ccuName,Integer type,Integer capabilities){
		long start = System.currentTimeMillis();
		log.info("findByCcu..根据主机号查询设备..ccuName:{}",ccuName);
		QueryWrapper<SynDevice> wrapper = new QueryWrapper<>();
		wrapper.eq("ccuId", ccuName);
		if(type!=null){
			wrapper.eq("type", type);
		}
		List<SynDevice> list = synDeviceService.list(wrapper);

		JSONArray jsonArray = null;
		if(!list.isEmpty()){
			jsonArray = new JSONArray();
			for (SynDevice synDevice : list) {
				JSONObject jsonObject = new JSONObject();
				String operateId = synDevice.getOperateId();
				jsonObject.set("deviceId", synDevice.getDeviceId());
				jsonObject.set("deviceName", synDevice.getDeviceName());
				jsonObject.set("roomName", synDevice.getRoomName());
				jsonObject.set("model", synDevice.getModel());

				if(capabilities != null && capabilities == 2){
					jsonObject.set("roomId", synDevice.getRoomId());
					jsonObject.set("typeId", operateId);

					String deviceModel_json_str = device_model_cache.get(operateId);
					if(StrUtil.isBlank(deviceModel_json_str)){
						QueryWrapper<DeviceModel> deviceModel_wrapper = new QueryWrapper<>();
						deviceModel_wrapper.eq("operateId", operateId);
						List<DeviceModel> model_list = deviceModelService.list(deviceModel_wrapper);
						if(!model_list.isEmpty()){
							DeviceModel deviceModel = model_list.get(0);
							device_model_cache.put(operateId, JSONUtil.toJsonStr(deviceModel));
							jsonObject.set("capabilities", deviceModel.getCapabilities());
						}
					}else{
						DeviceModel bean = JSONUtil.toBean(deviceModel_json_str, DeviceModel.class);
						jsonObject.set("capabilities", bean.getCapabilities());
					}
				}
				jsonArray.set(jsonObject);
			}
		}
		log.info("findByCcu..根据主机号查询设备..耗时:{}",System.currentTimeMillis()-start);
		return jsonArray;
	}

	public boolean synchronousDevice(String ccuName) {
		log.info("synchronousDevice..同步设备..ccuName:{}",ccuName);
		if(StrUtil.isBlank(ccuName)){
			throw new StatefulException(-20, "参数不能为空");
		}

		//查询房间信息
		Query regionQuery = new Query(Criteria.where("ccuName").is(ccuName));
		List<Region> region = mongoTemplate.find(regionQuery, Region.class);
		if (region.size() != 1) {
			log.error("主机：{} 没有找到匹配的房间",ccuName);
			throw new StatefulException(-1, "没有房间信息");
		}
		List<Room> rooms = region.get(0).getRooms();
		//查询设备信息
		Query regionQuery2 = new Query(Criteria.where("ccuName").is(ccuName));
		List<Device> device = mongoTemplate.find(regionQuery2, Device.class);
		if (device.isEmpty()) {
			log.error("主机：{} 没有找到匹配的设备",ccuName);
			throw new StatefulException(-2, "没有设备信息");
		}
		//查询场景
		Query regionQuery3 = new Query(Criteria.where("ccuName").is(ccuName));
		List<Scene> scenes = mongoTemplate.find(regionQuery3, Scene.class);


		List<SynDevice> synDeviceList = getSynDevices(ccuName, device, rooms,scenes);
		log.debug("要保存的设备：{}", JSONUtil.toJsonStr(synDeviceList));

		synDeviceService.remove(new QueryWrapper<SynDevice>().eq("ccuId", ccuName));
		return synDeviceService.saveBatch(synDeviceList);
	}

	@NotNull
	private List<SynDevice> getSynDevices(String ccuName, List<Device> device, List<Room> rooms,List<Scene> scenes) {
		List<SynDevice> synDeviceList = new ArrayList<>();
		for(Device d : device){
			if(d.getRoomId() == -1){
				continue;
			}
			String model = this.getDeviceType(d.getRealType());

			if(!"UNKNOWN".equals(model)){
				SynDevice synDevice = new SynDevice();
				synDevice.setDeviceId(d.getDevId());
				synDevice.setDeviceName(d.getName());
				synDevice.setOperateId(String.valueOf(d.getRealType()));
				synDevice.setRoomId(d.getRoomId());
				for(Room room : rooms){
					if(room.getId().equals(d.getRoomId())){
						synDevice.setRoomName(room.getName());
					}
				}
				synDevice.setType(1);
				synDevice.setCcuId(ccuName);
				synDevice.setMac(d.getMac());
				synDevice.setModel(model);

				synDeviceList.add(synDevice);
			}
		}
		if(scenes!=null && !scenes.isEmpty()){
			for (Scene scene : scenes){
				if(scene.getRoomId() == -1){
					continue;
				}
				SynDevice synDevice = new SynDevice();
				synDevice.setDeviceId(scene.getSceneId());
				synDevice.setDeviceName(scene.getName());
				synDevice.setOperateId("scene");
				synDevice.setRoomId(scene.getRoomId());
				for(Room room : rooms){
					if(room.getId().equals(scene.getRoomId())){
						synDevice.setRoomName(room.getName());
					}
				}
				synDevice.setType(2);
				synDevice.setCcuId(ccuName);
				synDevice.setModel("scene");

				synDeviceList.add(synDevice);
			}
		}
		return synDeviceList;
	}

	public String getDeviceType(Integer oid){
		String deviceModel_json_str = device_model_cache.get(String.valueOf(oid));
		if(StrUtil.isBlank(deviceModel_json_str)){
			QueryWrapper<DeviceModel> deviceModel_wrapper = new QueryWrapper<>();
			deviceModel_wrapper.eq("operateId", oid);
			List<DeviceModel> model_list = deviceModelService.list(deviceModel_wrapper);
			if(!model_list.isEmpty()){
				DeviceModel deviceModel = model_list.get(0);
				device_model_cache.put(String.valueOf(oid), JSONUtil.toJsonStr(deviceModel));
				return deviceModel.getModel();
			}
		}else{
			DeviceModel bean = JSONUtil.toBean(deviceModel_json_str, DeviceModel.class);
			return bean.getModel();
		}
		return "UNKNOWN";
	}

	public String getDeviceRealType(Integer oid){
		String deviceModel_json_str = device_model_cache.get(String.valueOf(oid));
		if(StrUtil.isBlank(deviceModel_json_str)){
			QueryWrapper<DeviceModel> deviceModel_wrapper = new QueryWrapper<>();
			deviceModel_wrapper.eq("operateId", oid);
			List<DeviceModel> model_list = deviceModelService.list(deviceModel_wrapper);
			if(!model_list.isEmpty()){
				DeviceModel deviceModel = model_list.get(0);
				device_model_cache.put(String.valueOf(oid), JSONUtil.toJsonStr(deviceModel));
				return deviceModel.getRealType();
			}
		}else{
			DeviceModel bean = JSONUtil.toBean(deviceModel_json_str, DeviceModel.class);
			return bean.getRealType();
		}
		return "UNKNOWN";
	}

	public DeviceModel getDeviceModel(Integer oid){
		String deviceModel_json_str = device_model_cache.get(String.valueOf(oid));
		if(StrUtil.isBlank(deviceModel_json_str)){
			QueryWrapper<DeviceModel> deviceModel_wrapper = new QueryWrapper<>();
			deviceModel_wrapper.eq("operateId", oid);
			List<DeviceModel> model_list = deviceModelService.list(deviceModel_wrapper);
			if(!model_list.isEmpty()){
				return model_list.get(0);
			}
		}else{
			return JSONUtil.toBean(deviceModel_json_str, DeviceModel.class);
		}
		return null;
	}

}
