package com.ikonke.konkeaialibabamcp.controller;


import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.constant.RedisKeys;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.entity.mysql.SynDevice;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import com.ikonke.konkeaialibabamcp.service.cdc.robot.CommunityRobot;
import com.ikonke.konkeaialibabamcp.service.cdc.spaces.SpacesService;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/cdc")
public class CDCController {

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private SpacesService spacesService;
	@Autowired
	private CommunityRobot robot;
	@Autowired
	private CdcHttpUtils cdcHttpUtils;
	@Autowired
	private SycDeviceService sycDeviceService;

	@PostMapping("/getCDCToken")
	public JSONObject getCDCToken(@RequestBody JSONObject actions){
		String sn = actions.getStr("sn");
		String ccuId = actions.getStr("ccuId");
		String ownerId = actions.getStr("ownerId");
		if(StrUtil.isBlank(sn)){
			JSONObject result = new JSONObject();
			result.set("msg", "参数不能为空");
			result.set("code", 500);
			return result;
		}
		log.info("getCDCToken..获取CDCToken..sn:{},ccuId:{},ownerId:{}",sn,ccuId,ownerId);

		// 每次重启都要删除缓存的兆慧用户数据
		cdcHttpUtils.delCDCUserCache(sn);

		QueryWrapper<CDCToken> wrapper = new QueryWrapper<>();
		wrapper.eq("state", 1);
		if(StrUtil.isNotBlank(ownerId)){
			wrapper.eq("CDCOwnerId", ownerId);
		}else{
			wrapper.eq("sn", sn);
		}
		String cdc_token = null;
		List<CDCToken> list = tokenService.list(wrapper);
		CDCToken token = null;
		if(list.size() == 1) {
			token = list.get(0);
		}

		if(StrUtil.isBlank(ccuId)){
			if(token != null){
				log.error("【{}】未传入主机号，删除数据库数据..",sn);
				tokenService.removeById(token);
			}
			cdcHttpUtils.delCDCUserCache(sn);
			//todo 主机号不存在,表明未绑定主机,需要不能使用AI功能
			JSONObject result = new JSONObject();
			result.set("msg", "未绑定主机");
			result.set("code", 500);
			return result;
		}


		if(list.size() == 1){
			cdc_token = token.getAccessToken();
			// 判断CDCToken是否过期
			LocalDateTime localDateTime = token.getCreateTime().plusDays(6);
			if(localDateTime.isBefore(LocalDateTime.now())){
				log.info("getCDCToken..CDCToken已过期..sn:{}",sn);
				cdc_token = cdcHttpUtils.getCDCToken(ccuId, ownerId);
				token.setAccessToken(cdc_token);
				token.setState(CDCToken.STATE_ENABLED);
				token.setCreateTime(LocalDateTime.now());
				tokenService.updateById(token);
			}

			if(StrUtil.isBlank(token.getSn()) || !token.getSn().equalsIgnoreCase(sn)){
				log.info("getCDCToken.1.更新CDCToken..sn:{},ccuId:{}",sn,ccuId);
				token.setSn(sn);
				tokenService.updateById(token);
			}
			if(StrUtil.isBlank(token.getCcuId()) || !token.getCcuId().equalsIgnoreCase(ccuId)){
				log.info("getCDCToken.2.更新CDCToken..sn:{},ccuId:{}",sn,ccuId);
				token.setCcuId(ccuId);
				tokenService.updateById(token);
			}

			if(StrUtil.isBlank(token.getAccessToken())){
				cdc_token = cdcHttpUtils.getCDCToken(ccuId, ownerId);
				token.setAccessToken(cdc_token);
				token.setCreateTime(LocalDateTime.now());
				tokenService.updateById(token);
			}

			// 同步主机设备,预计一天一次?
			sycDeviceService.synchronousDevice(ccuId);

		}else if(list.size() > 1){
			log.error("获取CDCToken失败，CDCToken数量大于1");
			return null;
		}else{
			//去建发获取CDCToken，有效期7天
			cdc_token = cdcHttpUtils.getCDCToken(ccuId, ownerId);
			CDCToken cdcToken = new CDCToken();
			cdcToken.setSn(sn);
			cdcToken.setCcuId(ccuId);
			cdcToken.setAccessToken(cdc_token);
			cdcToken.setState(CDCToken.STATE_ENABLED);
			cdcToken.setCreateTime(LocalDateTime.now());
			cdcToken.setAiSpeechUserId(sn);
			tokenService.save(cdcToken);
		}

		JSONObject result = new JSONObject();
		result.set("msg", "操作成功");
		result.set("code", 200);
		result.set("token", cdc_token);
		return result;
	}


	@GetMapping("/synCDCToken")
	public boolean synCDCToken(@RequestParam(name = "token") String token,
	                           @RequestParam(name = "sn") String sn,
	                           @RequestParam(name = "ccuName") String ccuName){
		long time = System.currentTimeMillis();
		log.info("synCDCToken..同步CDCToken..token:{},sn:{},ccuName:{}",token,sn,ccuName);
		try{
			CDCToken bySn = tokenService.findBySn(sn);
			if(bySn==null){
				bySn = new CDCToken();
				bySn.setSn(sn);
				bySn.setAccessToken(token);
				bySn.setState(CDCToken.STATE_ENABLED);
				bySn.setCcuId(CcuUtils.getCcuName(ccuName));
				bySn.setCreateTime(LocalDateTime.now());
				tokenService.save(bySn);
			}else{
				if(bySn.getAccessToken().equals(token)
						&& bySn.getSn().equals(sn)
						&& bySn.getCcuId().equals(CcuUtils.getCcuName(ccuName))){
					log.info("synCDCToken..不需要同步CDCToken..耗时:{}ms",System.currentTimeMillis()-time);
					return true;
				}else{
					cdcHttpUtils.delCDCUserCache(sn);

					bySn.setAccessToken(token);
					bySn.setRefreshToken(bySn.getAccessToken());
					bySn.setState(CDCToken.STATE_ENABLED);
					bySn.setCcuId(CcuUtils.getCcuName(ccuName));
					tokenService.updateById(bySn);
				}
			}
			log.info("synCDCToken..同步CDCToken成功..耗时:{}ms",System.currentTimeMillis()-time);
			return true;
		} catch (Exception e) {
			log.error("synCDCToken..同步CDCToken失败..token:{},sn:{},ccuName:{}",token,sn,ccuName);
			e.printStackTrace();
			return false;
		}
	}

	@GetMapping("/getSpacesList")
	public JSONArray getSpacesList(@RequestParam(name = "sn") String sn){
		log.info("【{}】getSpacesList..获取空间列表..",sn);
		JSONArray all = spacesService.findAll(sn);
		if(!all.isEmpty()){
			return all;
		}else{
			return null;
		}
	}


	@GetMapping("/getAppointmentTimeByRoomId")
	public JSONObject getAppointmentTimeByRoomId(@RequestParam(name = "sn")String sn,
	                                             @RequestParam(name = "time")String time,
	                                             @RequestParam(name = "roomId")String roomId,
	                                             @RequestParam(name = "roomSubspaceId",required = false)String roomSubspaceId){
		log.info("getAppointmentTimeByRoomId..获取预约时间..sn:{},time:{},roomId:{},roomSubspaceId:{}",sn,time,roomId,roomSubspaceId);
		return spacesService.getAppointmentTimeByRoomId(sn,time,roomId,roomSubspaceId);
	}



	//----------------------------

	@GetMapping("/bookingLitterRobot")
	public String bookingLitterRobot(@RequestParam(name = "sn")String sn){
		log.info("bookingLitterRobot--->预约垃圾机器人：垃圾代收下单:sn:{}",sn);
		return robot.bookingLitterRobot(sn,null);
	}
	@GetMapping("/bookingDeliveryRobot")
	public String bookingDeliveryRobot(@RequestParam(name = "sn")String sn){
		log.info("bookingDeliveryRobot--->预约配送机器人：机器人配送下单:sn:{}",sn);
		return robot.bookingDeliveryRobot(sn,null);
	}
}
