package com.ikonke.konkeaialibabamcp.event.listener;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.event.mode.DifyChatSteamEvent;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.utils.WebSocketUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class DifyChatSteamEventListener {

	@Value("${cdc.difyChatSteamMessages}")
	private String difyChatSteamMessages;

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private WebSocketUtil webSocketUtil;


	@Async
	@EventListener
	public void handleUserRegisteredEvent(DifyChatSteamEvent event) {
		long startTime = System.currentTimeMillis();
		log.info("【{}】：处理dify 异步 AI 聊天,input:{}", event.getSn(), event.getInput());
		try {
			synchronized(event.getSn()){
				if (!webSocketUtil.getWebSocket(event.getSn())) {
					log.error("未找到sn:{}的WebSocket连接,不处理对话", event.getSn());
					return;
				}

				QueryWrapper<CDCToken> wrapper = new QueryWrapper<>();
				wrapper.eq("sn", event.getSn());
				List<CDCToken> list = tokenService.list(wrapper);
				CDCToken token = list.get(0);

				String url = difyChatSteamMessages + "/dify/v2/chatSteamMessages?query="+event.getInput();
				log.info("【{}】：开始 dify 请求:{}",event.getSn(),url);
				String ai_result = HttpRequest.get(url)
						.header("ccuName", token.getCcuId() )
						.header("token", token.getAccessToken())
						.header("sn",token.getSn())
						.timeout(600000)
						.execute().body();

				log.info("dify请求返回11--->:{}",ai_result);
				ai_result = ai_result.replaceAll("\n", "").trim();
				log.info("dify请求返回22--->:{}",ai_result);

				JSONObject json = new JSONObject();
				if(!JSONUtil.isTypeJSON(ai_result)){
					json.put("msg", ai_result);
					json.put("type", "other");
				}else{
					json = JSONUtil.parseObj(ai_result);
					if(!json.containsKey("type")){
						json.put("type", "other");
					}
				}

				log.info("【{}】：dify请求返回:{}",event.getSn(),json);

				// 通过WebSocket发送消息给屏端
				webSocketUtil.sendToSingle(event.getSn(), json.toString());

				log.info("【{}】：dify异步请求耗时--->:{}",event.getSn(),System.currentTimeMillis() - startTime);
			}
		} catch (Exception e) {
			e.printStackTrace();
			Thread.currentThread().interrupt();
		}
	}

}
