package com.ikonke.konkeaialibabamcp.controller.open;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.controller.param.ResultResp;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping("/device")
public class DeviceController2 {

	@Autowired
	private SycDeviceService sycDeviceService;
	@Autowired
	private KonkeIotUtils konkeIotServer;

	@GetMapping("/triggerScene")
	public ResultResp triggerScene(@RequestParam(value = "ccuName")String ccuName,
	                               @RequestParam(value = "sceneId")String sceneId){
		log.info("triggerScene--->根据主机号和场景ID触发场景....ccuName:{},sceneId:{}",ccuName,sceneId);
		return ResultResp.setDate(konkeIotServer.optScene(CcuUtils.getCcuName(ccuName), sceneId));
	}

	@PostMapping("/saveTemporaryScene")
	public ResultResp saveTemporaryScene(@RequestParam(value = "ccuName") String ccuName,
	                        @RequestParam(value = "temporarySceneId") String temporarySceneId) {
		log.info("saveTemporaryScene..临时场景存储..ccuName:{},temporarySceneId:{}",ccuName,temporarySceneId);

		if(konkeIotServer.saveTemporaryScene(ccuName, temporarySceneId)){
			return ResultResp.setDate("保存成功");
		}else{
			return ResultResp.setBadDate("保存失败");
		}
	}

}
