package com.ikonke.konkeaialibabamcp.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ikonke.konkeaialibabamcp.constant.RedisKeys;
import com.ikonke.konkeaialibabamcp.controller.param.DifyStreamResponse;
import com.ikonke.konkeaialibabamcp.entity.cdc.UserEntity;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.event.mode.DifyChatSteamEvent;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import jakarta.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/dify/v2")
public class DifyControllerV2 {

	@Autowired
	private ICDCTokenService tokenService;
	@Autowired
	private WebClient webClient;
	@Autowired
	private CdcHttpUtils cdcHttpUtils;

	private final ApplicationEventPublisher eventPublisher;

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${cdc.difyChatSteamMessages}")
	private String difyChatSteamMessages;

	@Value("${dify.key}")
	private String dify_api_key;

	@Value("${cdc.mcpAuthorization}")
	private String mcpAuthorization;

	public DifyControllerV2(ApplicationEventPublisher eventPublisher) {
		this.eventPublisher = eventPublisher;
	}

//	@PostConstruct
//	public void init() {
//		Object redisValue = redisTemplate.opsForValue().get(RedisKeys.KONKE_DIFY_API_KEY);
//
//		// 如果Redis中有值，则使用Redis中的值覆盖配置文件的值
//		if (redisValue != null) {
//			this.dify_api_key = redisValue.toString();
//			log.info("Using Dify API key from Redis: {}", this.dify_api_key);
//		} else {
//			log.info("Using Dify API key from configuration file: {}", this.dify_api_key);
//		}
//	}



	/**
	 * 思必驰 demo
	 * https://www.duiopen.com/docs/ct_dsk_protocol
	 *
	 */
	@RequestMapping(value = "/bottomSkill", method = RequestMethod.POST, consumes = "application/json")
	@ResponseBody
	public JSONObject bottomSkill(@RequestBody JSONObject jsonObject) {
		Long timestamp = System.currentTimeMillis();
		JSONObject result = jsonObject.getJSONObject("request");
		JSONObject context = jsonObject.getJSONObject("context");
		JSONObject device = context.getJSONObject("device");
		String deviceName = device.getStr("deviceName");//这是屏端的sn

		log.info("【{}】：思必驰 bottomSkill..请求参数:{}",deviceName,jsonObject.toString());

		String type = result.get("type").toString();
		String input;  //请求文本
		String res = "{'version': '1.0','response': {'speak': {'type': 'text','text': '%s','ssml': 'SSML markup text string to speak'}},'shouldEndSession': %b}"; //忽略了部分DSK协议字段,shouldEndSession字段决定是否结束本轮对话

		JSONObject response = JSONUtil.parseObj(String.format(res, "error", true));  // 响应报文
		JSONArray slots;
		try {
			slots = result.getJSONArray("inputs");
			input = slots.getJSONObject(0).get("input").toString();

			//根据userId获取到对应的主机号等信息
			QueryWrapper<CDCToken> wrapper = new QueryWrapper<>();
			wrapper.eq("aiSpeechUserId", deviceName);
			List<CDCToken> list = tokenService.list(wrapper);
			if(list.size() == 1){
				CDCToken token = list.get(0);
				if(StrUtil.isBlank(token.getCcuId())){
					res = String.format(res, "未绑定主机", false);
					response = JSONUtil.parseObj(res);
				}


				String cleanedInput = input.replaceAll("\\[\\s*\\]", "").replaceAll("【\\s*】", "").trim();
				if (cleanedInput.isEmpty() || cleanedInput.equals("[]") || cleanedInput.equals("【】")) {
					// 处理空列表的情况
					cleanedInput = ""; // 或者设置默认值
				}
				if(StrUtil.isNotBlank(cleanedInput)){
					// 异步执行对话????
					eventPublisher.publishEvent(new DifyChatSteamEvent(this,token.getSn(), cleanedInput));
				}



				res = String.format(res, "正在思考中", false);
				response = JSONUtil.parseObj(res);
			}else if(list.size() > 1){
				log.error("【{}】：获取CDCToken失败，CDCToken数量大于1",deviceName);
				res = String.format(res, "绑定异常", false);
				response = JSONUtil.parseObj(res);
			}else{
				res = String.format(res, "未绑定主机绑定", false);
				response = JSONUtil.parseObj(res);
			}
		} catch (Exception e) {
			res = String.format(res, "服务器异常,稍后重试.", false);
			response = JSONUtil.parseObj(res);
			e.printStackTrace();
		} finally {
			log.info("【{}】：思必驰 bottomSkill..响应时间={}",deviceName,(System.currentTimeMillis()-timestamp));
			return response;
		}
	}


	@GetMapping("/chatSteamMessages")
	public Flux<String> chatSteamMessages(@RequestParam(name = "query") String query,
	                                      @RequestHeader("sn") String sn){
		log.info("【{}】：开始 流式 对话, query:{}",sn,query);

		QueryWrapper<CDCToken> wrapper = new QueryWrapper<>();
		wrapper.eq("sn", sn);
		List<CDCToken> list = tokenService.list(wrapper);
		if(list.size() != 1){
			return Flux.just("未绑定主机");
		}
		CDCToken token = list.get(0);
		if(StrUtil.isBlank(token.getCcuId())){
			return Flux.just("未绑定主机");
		}
		if(StrUtil.isBlank(token.getAccessToken())){
			// 没有建发的token,有效期7天
			String cdc_token = cdcHttpUtils.getCDCToken(token.getCcuId(), token.getCDCOwnerId());
			token.setAccessToken(cdc_token);
			token.setState(CDCToken.STATE_ENABLED);
			token.setCreateTime(LocalDateTime.now());
			tokenService.updateById(token);
		}
		if(StrUtil.isBlank(token.getAccessToken())){
			log.error("未获取到建发的token,结束对话");
			return Flux.just("未绑定社区账号");
		}

		UserEntity userEntity = cdcHttpUtils.getOwner(sn);

		//workflows/run
		String url = "http://172.17.12.12:8088/v1/chat-messages";

		JSONObject inputs = new JSONObject();
		inputs.set("Authorization",mcpAuthorization);
		inputs.set("ccuName",token.getCcuId());
		inputs.set("sn",sn);
		inputs.set("token",token.getAccessToken());
		if(StrUtil.isNotBlank(userEntity.getCommunityCode())){
			inputs.set("communityCode",userEntity.getCommunityCode());
		}else{
			inputs.set("communityCode","communityCode");
		}
		inputs.set("communityId",userEntity.getCommunityId());
		inputs.set("easId",userEntity.getEasId());
		inputs.set("roomId",userEntity.getRoomInfo().getRoomId());
		inputs.set("roomName",userEntity.getRoomInfo().getRoomId());
		inputs.set("buildingId",userEntity.getRoomInfo().getBuildingId());
		inputs.set("userPhone",userEntity.getPhoneNum());
		inputs.set("userName",userEntity.getPhoneNum());

		JSONObject body = new JSONObject();
		body.set("inputs",inputs);
		body.set("query",query);
		body.set("response_mode","streaming");//blocking 阻塞模式,streaming 流式模式
		body.set("user",sn);


		String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
		Object redis_conversationId =redisTemplate.opsForValue().get(redis_key);
		String conversationId = null;
		if(redis_conversationId!=null){
			conversationId = redis_conversationId.toString();
		}
		CDCToken bySn = null;
		if(StrUtil.isBlank(conversationId)){
			bySn = tokenService.findBySn(sn);
			if(bySn!=null && StrUtil.isNotBlank(bySn.getConversationId())){
				conversationId = bySn.getConversationId();
				body.set("conversation_id",conversationId);//一个user一个会话
			}
		}else{
			body.set("conversation_id",conversationId);
		}

		log.info("dify key:{} ,流式 对话 body:{}",dify_api_key,body);


		return webClient.post()
				.uri(url)
				.headers(httpHeaders -> {
					httpHeaders.setContentType(MediaType.APPLICATION_JSON);
					httpHeaders.setBearerAuth(dify_api_key);
				})
				.bodyValue(body)
				.retrieve()
				.bodyToFlux(DifyStreamResponse.class)//实体转换
				.timeout(Duration.ofMinutes(1))//设置超时时间1分钟
				.filter(this::shouldInclude) // 过滤掉不需要的数据【根据需求增加】
				.map((DifyStreamResponse difyStreamResponse) -> convertToCustomResponseAsync(difyStreamResponse, sn, token.getCcuId(), token.getAccessToken(), redis_conversationId)) // 异步转换【如果返回格式自定义则通过异步转换实现】
				.onErrorResume(throwable -> {
					log.info("异常输出："+throwable.getMessage());
					return null;
				});
	}

	private String convertToCustomResponseAsync(DifyStreamResponse difyStreamResponse,String sn,String ccuName,String token,Object redis_conversationId) {
		if(redis_conversationId == null && StrUtil.isNotBlank(difyStreamResponse.getConversation_id())){//conversationId为null表示第一次对话
			// 保存最后一次对话的task_id，后续可暂停对话
			String redis_task_key =  RedisKeys.KONKE_DIFY_LAST_STEAM_CHAT_TASK_ID+ sn;
			redisTemplate.opsForValue().set(redis_task_key, difyStreamResponse.getTask_id());

			// 保存conversationId
			String conversationId = difyStreamResponse.getConversation_id();
			String redis_key =  RedisKeys.KONKE_DIFY_CONVERSATION_ID+ sn;
			redisTemplate.opsForValue().set(redis_key, conversationId);

			CDCToken bySn = tokenService.findBySn(sn);
			if(bySn!=null){
				bySn.setConversationId(conversationId);
				tokenService.updateById(bySn);
			}else{
				log.error("这一步应该从不会触发............");
				bySn = new CDCToken();
				bySn.setSn(sn);
				bySn.setCcuId(CcuUtils.getCcuName(ccuName));
				bySn.setAccessToken(token);
				bySn.setCreateTime(LocalDateTime.now());
				bySn.setState(CDCToken.STATE_ENABLED);
				bySn.setConversationId(conversationId);
				tokenService.save(bySn);
			}
		}
		String answer = difyStreamResponse.getAnswer();
		if(StrUtil.isBlank(answer)){
			return "";
		}else{
			return answer;
		}
	}

	private boolean shouldInclude(DifyStreamResponse streamResponse) {
		// 示例：只要message节点的数据和message_end节点的数据
		if (streamResponse.getEvent().equals("message")
				|| streamResponse.getEvent().equals("message_end")) {
			return true;
		}
		return false;
	}
}
