package com.ikonke.konkeaialibabamcp.aitools;


import com.ikonke.konkeaialibabamcp.service.cdc.property.Property;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

/**
 * 物业相关
 */
@Slf4j
@Service
public class CDCPropertyTools {

	private final Property property;

	public CDCPropertyTools(Property property) {
		this.property = property;
	}



	@Tool(description = "社区物业相关：新增物业工单")
	public String addWorkOrder(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                           @ToolParam(description = "工单描述,如：21栋二单元3楼的左楼道的灯坏了,请派人来维修一下。")String description){
		log.info("【{}】mcp调用--->社区物业相关：新增物业工单:description:{}",sn,description);
		return property.addWorkOrder(sn,description);
	}
}
