package com.ikonke.konkeaialibabamcp.service.cdc.spaces;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.StatefulException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.service.cdc.CdcHttpUtils;
import com.ikonke.konkeaialibabamcp.utils.CDCUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@Component
public class SpacesService {

	@Value("${cdc.url}")
	private String cdcUrl;
	@Value("${cdc.getListSpacesRoomUrl}")
	private String getListSpacesRoomUrl;
	@Value("${cdc.getSpacesRoomDetailUrl}")
	private String getSpacesRoomDetailUrl;
	@Value("${cdc.getSpacesRoomBookingUrl}")
	private String getSpacesRoomBookingUrl;
	@Value("${cdc.bookingSpacesRoomUrl}")
	private String bookingSpacesRoomUrl;
	@Value("${cdc.spacesRoomOrderUrl}")
	private String spacesRoomOrderUrl;

	// 获取可领取的优惠卷
	@Value("${cdc.spacesCoupons.getSpacesCouponsListUrl}")
	private String getSpacesCouponsListUrl;
	// 领取单张优惠卷
	@Value("${cdc.spacesCoupons.receiveSpacesCouponsUrl}")
	private String receiveSpacesCouponsUrl;
	// 获取用户已经领取的优惠卷
	@Value("${cdc.spacesCoupons.getUserCouponsUrl}")
	private String getUserCouponsUrl;
	// 一键领取优惠卷
	@Value("${cdc.spacesCoupons.oneClickClaimCouponUrl}")
	private String oneClickClaimCouponUrl;



	@Autowired
	private CdcHttpUtils cdcHttpUtils;

	// 查询所有空间
	public JSONArray findAll(String sn) {
		// 小区功能区列表
		String s = cdcHttpUtils.get(getListSpacesRoomUrl, sn);
		JSONObject spacesJson = new JSONObject(s);
		if(spacesJson.getInt("code") != 200){
			throw new StatefulException(51, "查询会所空间列表失败");
		}else{
			JSONArray data = spacesJson.getJSONArray("data");
			JSONArray spacesList = data.getJSONArray(1);

			JSONArray response = new JSONArray();
			for( int i = 0; i < spacesList.size(); i++){
				JSONObject jsonObject = spacesList.getJSONObject(i);
				String status = jsonObject.getStr("status");//0=正常；1=维护中(任何时段都不可预定)
				String name = jsonObject.getStr("name");//空间名
				String type = jsonObject.getStr("type");//1=共享型，2=独占式，3=仅展示，4=跳转小程序
				String id = jsonObject.getStr("id");
				Integer main_userCount = jsonObject.getInt("userCount");//当前里面的用户数，每日凌晨改成0
				if(main_userCount==null){
					main_userCount = 0;
				}
				String subspaceType = jsonObject.getStr("subspaceType");//0:单独空间 1:内分子空间

				if("0".equals(status)){
					JSONObject response_spaces = new JSONObject();
					response_spaces.set("roomId",id);
					response_spaces.set("roomName",name);
					response_spaces.set("peopleInUseNumber",main_userCount);
					Double price = 0.0;

					//查详情-子空间-正常
					String s1 = cdcHttpUtils.get(getSpacesRoomDetailUrl + id, sn);
					JSONObject spacesRoomDetailJson = JSONUtil.parseObj(s1);
					if(spacesRoomDetailJson.getInt("code") == 200){
						JSONObject result = spacesRoomDetailJson.getJSONObject("data");

						price = result.getDouble("price");
						response_spaces.set("price",price);

						if(result.containsKey("subspacePd") && StrUtil.isNotBlank(result.getStr("subspacePd"))){
							JSONArray subspacePd = result.getJSONArray("subspacePd");//子空间
							JSONArray child = new JSONArray();
							for( int j = 0; j < subspacePd.size(); j++){
								JSONObject jsonObject1 = subspacePd.getJSONObject(j);
								String subspacePdName = jsonObject1.getStr("name");
								String subspacePdId = jsonObject1.getStr("id");

								JSONObject childJsonObject = new JSONObject();
								childJsonObject.set("subspaceName", subspacePdName);
								childJsonObject.set("subspaceId", subspacePdId);
								child.set(childJsonObject);
							}
							response_spaces.set("subspaces", child);
						}
					}
					response.set(response_spaces);
				}

			}
			return response;
		}
	}

	/**
	 * 查询预约时间
	 */
	public JSONObject getAppointmentTimeByRoomId(String sn,String paramTime,String roomId,String roomSubspaceIds) {
		if(StrUtil.isBlank(sn) || StrUtil.isBlank(roomId) || StrUtil.isBlank(paramTime)){
			return null;
		}
		// 查询预约时间
		JSONObject response = new JSONObject();
		try {
			Date date = DateUtil.parse(paramTime);
			String time = DateUtil.formatDate(date);

			response.set("roomId",roomId);
			response.set("date",time);

			JSONObject param = new JSONObject();
			param.set("time", time);
			param.set("id", roomId);
			if(StrUtil.isNotBlank(roomSubspaceIds)){
				response.set("subspaceIds", roomSubspaceIds);
				List<String> roomSubspaceIdsList = new ArrayList<>();
				String[] split = roomSubspaceIds.split(",");
				for(String roomSubspaceId : split){
					roomSubspaceIdsList.add(roomSubspaceId.trim());
				}
				param.set("roomSubspaceIds", roomSubspaceIdsList);
			}

			String post = cdcHttpUtils.post(getSpacesRoomBookingUrl, sn, param.toString());
			JSONObject jsonObject = new JSONObject(post);
			if(jsonObject.getInt("code") == 200){
				JSONObject dataJson = jsonObject.getJSONObject("data");
				JSONObject firstDayJson = dataJson.getJSONObject("firstDay");

				JSONArray info = firstDayJson.getJSONArray("info");

				int timeSegmentIndex = CDCUtils.getTimeSegmentIndex(DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
				if(timeSegmentIndex<0){
					timeSegmentIndex = 0;
				}

				JSONArray response_time = new JSONArray();
				for( int j = timeSegmentIndex; j < 48; j++){
					Integer number = info.getInt(j);//0=不可预定 1=可预订 2=已被预定
					JSONObject jsonObject1 = new JSONObject();
					jsonObject1.set("timeSegment", CDCUtils.time_segment[j]);

					if(number == 1){
						jsonObject1.set("availability", "可预订");
					}else if(number == 2){
						jsonObject1.set("availability", "已被预定");
					}else{
						jsonObject1.set("availability", "不可预定");
					}
					response_time.set(jsonObject1);
				}
				response.set("time", response_time);
			}else{
				response.set("time", "不可预约");
			}
		}catch (Exception e) {
			e.printStackTrace();
			throw new StatefulException(52, "查询会所预约情况失败");
		}
		return response;
	}

	/**
	 *
	 * 预约订单，不使用钱 使用了优惠卷
	 */
	public boolean bookingOrder(String sn,String beginTime,String endTime,String roomId,String subspaceId,int userQuantity,String couponId){
		if(StrUtil.isBlank(sn) || StrUtil.isBlank(roomId) || StrUtil.isBlank(beginTime) || StrUtil.isBlank(endTime) || StrUtil.isBlank(couponId) || userQuantity<1){
			throw new StatefulException(530, "参数错误");
		}
		Date begin_time = DateUtil.parse(beginTime);
		Date end_time = DateUtil.parse(endTime);
		if(begin_time.getTime() >= end_time.getTime()){
			throw new StatefulException(530, "开始时间不能大于结束时间");
		}
		if(!DateUtil.formatDate(begin_time).equals(DateUtil.formatDate(end_time))){
			throw new StatefulException(531, "不能跨天预约");
		}
		if(begin_time.getTime() < System.currentTimeMillis()){
			throw new StatefulException(532, "不能预约历史时间");
		}
		if(DateUtil.between(new Date(), end_time, DateUnit.DAY) > 7){
			throw new StatefulException(533, "不能预约超过7天");
		}
		int begin_num = CDCUtils.getTimeSegmentIndex(beginTime);
		int end_num = CDCUtils.getTimeSegmentIndex(endTime);
		String use_time = DateUtil.formatDate(begin_time);

		//校验预约时间
		JSONObject booking_time_param = new JSONObject();
		booking_time_param.set("time", use_time);
		booking_time_param.set("id", roomId);
		if(StrUtil.isNotBlank(subspaceId)){
			List<String> roomSubspaceIdsList = new ArrayList<>();
			roomSubspaceIdsList.add(subspaceId);
			booking_time_param.set("roomSubspaceIds", roomSubspaceIdsList);
		}
		String post = cdcHttpUtils.post(getSpacesRoomBookingUrl, sn, booking_time_param.toString());
		JSONObject jsonObject = new JSONObject(post);
		if(jsonObject.getInt("code") == 200){
			JSONObject dataJson = jsonObject.getJSONObject("data");
			JSONObject firstDayJson = dataJson.getJSONObject("firstDay");
			JSONArray info = firstDayJson.getJSONArray("info");
			//0=不可预定 1=可预订 2=已被预定
			boolean begin_use = info.getInt(begin_num) == 1;
			boolean end_use = info.getInt(end_num) == 1;
			if(!begin_use || !end_use){
				throw new StatefulException(534, "该时间段已经不能被预约了");
			}
		}else{
			throw new StatefulException(535, "该天不能预约");
		}
		//校验优惠券
		String s = cdcHttpUtils.get(getUserCouponsUrl+"?status=0&roomId="+roomId, sn);
		JSONObject coupons = JSONUtil.parseObj(s);
		if(coupons.getInt("code") == 200){
			JSONArray rows = coupons.getJSONArray("rows");
			for (int i = 0; i < rows.size(); i++){
				JSONObject coup = rows.getJSONObject(i);
				String coupons_id = coup.getStr("id");
				if(coupons_id.equals(couponId)){
					String discountTime = coup.getStr("discount");//抵用时长（只能是0.5的整数倍）
					int time = Integer.parseInt(discountTime) * 30;
					if(DateUtil.between(begin_time, end_time, DateUnit.MINUTE) > time){
						throw new StatefulException(536, "优惠卷的抵扣时间小于了您选择的时间");
					}
					String coup_start_time_str = coup.getStr("startTime");
					Date coup_start_time = DateUtil.parse(coup_start_time_str);
					if(begin_time.getTime() < coup_start_time.getTime()){
						throw new StatefulException(537, "优惠卷不能使用,因为超过了优惠券的有效期");
					}
					String coup_end_time_str =coup.getStr("endTime");
					Date coup_end_time = DateUtil.parse(coup_end_time_str);
					if(end_time.getTime() > coup_end_time.getTime()){
						throw new StatefulException(537, "优惠券不能使用,因为超过了优惠券的有效期");
					}
				}
			}
		}else{
			throw new StatefulException(538, "不能使用该优惠券,请联系工作人员");
		}

		//====================================


		JSONObject param = new JSONObject();
		param.set("roomId", roomId);
		if(StrUtil.isNotBlank(subspaceId)){
			param.set("roomSubspaceId", subspaceId);
		}
		param.set("useTime", use_time);
		param.set("useEndTime", use_time);
		param.set("beginTime", begin_num);
		param.set("endTime", end_num);
		param.set("orderNum", userQuantity);
		param.set("isRenew", 0);
		param.set("userCouponsId", couponId);
		param.set("payFlag", "false");


		String spacesRoomOrder_post = cdcHttpUtils.post(spacesRoomOrderUrl, sn, param.toString());
		JSONObject spacesRoomOrder = new JSONObject(spacesRoomOrder_post);
		if(spacesRoomOrder.getInt("code") == 200){
			return true;
		}else{
			throw new StatefulException(539, "预约失败");
		}
	}

	/**
	 * 获取可领取的优惠券列表
	 */
	public JSONArray getSpacesCouponsList(String sn){
		String couponsListStr = cdcHttpUtils.get(getSpacesCouponsListUrl, sn);
		JSONObject coupons = JSONUtil.parseObj(couponsListStr);
		if(coupons.getInt("code") == 200){
			JSONArray response = new JSONArray();

			JSONArray couponsList = coupons.getJSONArray("rows");
			for (int i = 0; i < couponsList.size(); i++){
				JSONObject couponsListJson = couponsList.getJSONObject(i);
				if(couponsListJson.getInt("userCouponsStatus") == 0){//0=未领取；1=可用 ; 2 =已过期 ;3=未开始
					JSONObject response_couponsList = new JSONObject();
					response_couponsList.set("couponsId", couponsListJson.getStr("id"));
					response_couponsList.set("couponsName", couponsListJson.getStr("name"));
					response_couponsList.set("roomId", couponsListJson.getStr("roomId"));

					String discountTime = couponsListJson.getStr("discount");//抵用时长（只能是0.5的整数倍）
					int time = Integer.parseInt(discountTime) * 30;
					response_couponsList.set("deductionTime", time);

					response_couponsList.set("startTime", couponsListJson.getStr("startTime"));
					response_couponsList.set("endTime", couponsListJson.getStr("endTime"));

					response.set(response_couponsList);
				}
			}
			return response;
		}
		return null;
	}

	/**
	 * 领取一张优惠券
	 */
	public boolean receiveSpacesCoupons(String sn,String couponId){
		JSONObject param = new JSONObject();
		String post = cdcHttpUtils.post(receiveSpacesCouponsUrl + "/" + couponId, sn, param.toString());
		JSONObject jsonObject = JSONUtil.parseObj(post);
		if(jsonObject.getInt("code") == 200){
			return true;
		}
		return false;
	}

	/**
	 * 一键领取优惠券
	 */
	public boolean oneClickClaimCoupon(String sn){
		JSONObject param = new JSONObject();
		String post = cdcHttpUtils.post(oneClickClaimCouponUrl, sn, param.toString());
		JSONObject jsonObject = JSONUtil.parseObj(post);
		if(jsonObject.getInt("code") == 200){
			return true;
		}
		return false;
	}

	/**
	 * 获取用户已领取的优惠券列表
	 */
	public JSONArray getUserCoupons(String sn,String roomId){
		if(StrUtil.isBlank(sn) || StrUtil.isBlank(roomId)){
			return null;
		}
		String url = getUserCouponsUrl+"?status=0";
		if(StrUtil.isNotBlank(roomId)){
			url = url+"&roomId="+roomId;
		}
		String s = cdcHttpUtils.get(url, sn);
		JSONObject coupons = JSONUtil.parseObj(s);
		JSONArray response = new JSONArray();
		if(coupons.getInt("code") == 200){
			JSONArray rows = coupons.getJSONArray("rows");
			for (int i = 0; i < rows.size(); i++){
				JSONObject coup = rows.getJSONObject(i);

				JSONObject coupon_json = new JSONObject();
				coupon_json.set("couponsId", coup.getStr("id"));
				coupon_json.set("couponsName", coup.getStr("name"));
				coupon_json.set("roomId", coup.getStr("roomId"));

				String discountTime = coup.getStr("discount");//抵用时长（只能是0.5的整数倍）
				int time = Integer.parseInt(discountTime) * 30;
				coupon_json.set("deductionTime", time);

				coupon_json.set("startTime", coup.getStr("startTime"));
				coupon_json.set("endTime", coup.getStr("endTime"));
				response.set(coupon_json);
			}
			return response;
		}else{
			return null;
		}
	}



}
