package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.core.util.StrUtil;

import java.awt.*;

public class ColorUtil {

    public static Color getColor(String value){
        if(StrUtil.isEmpty(value)){
            return Color.white;
        }
        Color c = null;
        switch (value){
            case "Red":
                c = Color.red;
                break;
            case "Yellow":
                c = Color.yellow;
                break;
            case "Blue":
                c = Color.blue;
                break;
            case "Green":
                c = Color.green;
                break;
            case "White":
                c = Color.white;
                break;
            case "Black":
                c = Color.black;
                break;
            case "Cyan":
                c = Color.cyan;
                break;
            case "Purple":
                c = Color.magenta;
                break;
            case "Orange":
                c = Color.orange;
                break;
            default:
                c = Color.white;
                break;
        }
        return c;
    }

    public static String getColorByRgb(int r,int g,int b){
        Color c = new Color(r,g,b);
        Color Violet = new Color(238,130,238);
        Color Magenta = new Color(	255,0,255);
        Color Indigo = new Color(75,0,130);
        Color SlateBlue = new Color(106,90,205);
        Color DarkBlue = new Color(0,0,139);
        Color SkyBlue = new Color(135,206,235);
        Color DarkCyan = new Color(0,139,139);
        Color Beige = new Color(245,245,220);
        Color Brown = new Color(165,42,42);

        if(Color.red.equals(c)){
            return "Red";
        }else if(Color.yellow.equals(c)){
            return "Yellow";
        }else if(Color.blue.equals(c)){
            return "Blue";
        }else if(Color.green.equals(c)){
            return "Green";
        }else if(Color.white.equals(c)){
            return "White";
        }else if(Color.black.equals(c)){
            return "Black";
        }else if(Color.cyan.equals(c)){
            return "Cyan";
        }else if(Color.magenta.equals(c)){
            return "Purple";
        }else if(Color.orange.equals(c)){
            return "Orange";
        }else if(Color.PINK.equals(c)){
            return "Pink";
        }else if(Violet.equals(c)){
            return "Violet";
        }else if(Magenta.equals(c)){
            return "Magenta";
        }else if(Indigo.equals(c)){
            return "Indigo";
        }else if(SlateBlue.equals(c)){
            return "SlateBlue";
        }else if(DarkBlue.equals(c)){
            return "DarkBlue";
        }else if(SkyBlue.equals(c)){
            return "SkyBlue";
        }else if(DarkCyan.equals(c)){
            return "DarkCyan";
        }else if(Beige.equals(c)){
            return "Beige";
        }else if(Brown.equals(c)){
            return "Brown";
        }else{
            float[] hsb = getHSBToRGB(r,g,b);
            if(hsb[1] < 0.1 && hsb[2] > 0.9){
                return "White";
            }else if(hsb[2] < 0.1){
                return "Black";
            }
            float deg = hsb[0]*360;
            if (deg >= 0 && deg < 30){
                return "Red";
            } else if (deg >= 30 && deg < 90){
                return "Yellow";
            } else if (deg >= 90 && deg < 150){
                return "Green";
            }else if (deg >= 150 && deg < 210){
                return "Cyan";
            }else if (deg >= 210 && deg < 270){
                return "Blue";
            }else if (deg >= 270 && deg < 330){
                return "Purple";
            }else{
                return "Red";
            }
        }
    }


    /**
     * 根据RGB获取HSB
     * @param red
     * @param green
     * @param blue
     * @return HSB 0:色相(0~360，包括0和360) 1:饱和度(0~1，包括0和1) 2:亮度(0~1，包括0和1)
     */
    public static float[] getHSBToRGB(int red,int green,int blue) {
        if(red<0 || green<0 || blue<0){
            //若rgb为负数,初始化为白色
            red = 255;
            green = 255;
            blue = 255;
        }
        float[] hsbVals = new float[3];
        Color.RGBtoHSB(red, green, blue, hsbVals);
        hsbVals[0] = hsbVals[0]*360;
        return hsbVals;
    }
}
