package com.ikonke.konkeaialibabamcp.service.cdc;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ikonke.konkeaialibabamcp.entity.cdc.UserEntity;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import com.ikonke.konkeaialibabamcp.service.mysqlservice.ICDCTokenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CdcHttpUtils {

	public static Cache<String, String> CDCTokenCache = CacheUtil.newLRUCache(1024);

	@Value("${cdc.getOwnerUrl}")
	private String getOwnerUrl;

	@Value("${cdc.ownerLoginUrl}")
	private String ownerLoginUrl;

	@Value("${cdc.timeout}")
	private Integer timeout;

	@Autowired
	private ICDCTokenService tokenService;


	public UserEntity getOwner(String sn){
		CDCToken bySn = tokenService.findBySn(sn);
		return getOwner(bySn);
	}

	public String getCDCToken(String ccuId,String ownerId){
		log.info("去建发登录业主获取token,ccuId:{},ownerId:{}",ccuId,ownerId);
		JSONObject body = new JSONObject();
		body.set("loginType",6);
		body.set("gateway", ccuId);
		body.set("ownerId", ownerId);
		String body1 = HttpRequest.post(ownerLoginUrl)
				.body(body.toString())
				.timeout(timeout)
				.execute().body();
		JSONObject jsonObject = JSONUtil.parseObj(body1);
		if(jsonObject.getInt("code") == 200){
			JSONObject jsonObject_data = jsonObject.getJSONObject("data");
			return jsonObject_data.getStr("access_token");
		}else{
			log.error("【{}】登录业主获取token失败:{}",ccuId,body1);
		}
		return null;
	}

	/**
	 * 获取用户信息
	 *
	 */
	public UserEntity getOwner(CDCToken bySn){
		log.info("【{}】去建发获取业主信息,ccu:{}",bySn.getSn(),bySn.getCcuId());
		if(CDCTokenCache.get(bySn.getSn())!=null){
			String s = CDCTokenCache.get(bySn.getSn());
			return JSONUtil.toBean(s, UserEntity.class);
		}else{
			String body = HttpRequest.get(getOwnerUrl)
					.header("X-token", bySn.getAccessToken())
					.header("gateway-id", bySn.getCcuId())
					.timeout(timeout)
					.execute().body();

			JSONObject jsonObject = JSONUtil.parseObj(body);
			if(jsonObject.getInt("code") == 200){
				UserEntity userEntity = JSONUtil.toBean(jsonObject.getJSONObject("data"), UserEntity.class);
				CDCTokenCache.put(bySn.getSn(),jsonObject.getJSONObject("data").toString());
				return userEntity;
			}else{
				log.error("【{}】获取用户信息失败:{}",bySn.getSn(),body);
				return null;
			}
		}
	}


	/**
	 * get请求
	 */
	public String get(String url, String sn) {
		long start = System.currentTimeMillis();
		log.info("【{}】建发get请求：url：{}",sn,url);
		CDCToken bySn = tokenService.findBySn(sn);
		UserEntity userEntity = getOwner(bySn);
		if(userEntity==null || userEntity.getRoomInfo() == null){
			log.info("【{}】获取用户信息失败",sn);
			return null;
		}
		String body = HttpRequest.get(url)
				.header("X-token",bySn.getAccessToken())
				.header("gateway-id",bySn.getCcuId())
				.header("space-yr",userEntity.communityId)
				.header("communityId",userEntity.communityId)
				.header("space-phone",userEntity.phoneNum)
				.header("gateway",bySn.getCcuId())
				.header("roomId",userEntity.roomInfo.roomId)
				.header("easId",userEntity.easId)
				.header("Propertyid",userEntity.communityId)
				.timeout(20000)//超时，毫秒
				.execute().body();
		log.info("【{}】建发get请求结果：url：{},body:{},耗时：{}",sn,url,body,System.currentTimeMillis()-start);
		return body;
	}

	public String post(String url, String sn,String body) {
		long start = System.currentTimeMillis();
		log.info("【{}】建发post请求：url：{},body:{}",sn,url,body);
		CDCToken bySn = tokenService.findBySn(sn);
		UserEntity userEntity = getOwner(bySn);
		if(userEntity==null || userEntity.roomInfo== null){
			log.info("【{}】获取用户信息失败",sn);
			return null;
		}
		String result = HttpRequest.post(url)
				.header("X-token",bySn.getAccessToken())
				.header("gateway-id",bySn.getCcuId())
				.header("space-yr",userEntity.communityId)
				.header("communityId",userEntity.communityId)
				.header("space-phone",userEntity.phoneNum)
				.header("gateway",bySn.getCcuId())
				.header("roomId",userEntity.roomInfo.roomId)
				.header("easId",userEntity.easId)
				.header("Propertyid",userEntity.communityId)
				.body(body)
				.timeout(20000)
				.execute().body();
		log.info("【{}】建发post请求结果：url：{},body:{},耗时：{}",sn,url,result,System.currentTimeMillis()-start);
		return result;
	}
}
