package com.ikonke.konkeaialibabamcp.aitools;


import com.ikonke.konkeaialibabamcp.entity.mongodb.DeviceStatus;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.service.mongdbservice.DeviceStatusService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class BatchDeviceTools {

	private final DeviceStatusService deviceStatusUtil;
	private final KonkeIotUtils konkeIotServer;
	private final SycDeviceService sycDeviceService;

	public BatchDeviceTools(DeviceStatusService deviceStatusUtil, KonkeIotUtils konkeIotServer, SycDeviceService sycDeviceService){
		this.deviceStatusUtil = deviceStatusUtil;
		this.konkeIotServer = konkeIotServer;
		this.sycDeviceService = sycDeviceService;
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID查询设备状态信息.")
	public DeviceStatus findDeviceState(@ToolParam(description = "主机号") String ccuName,
	                                    @ToolParam(description = "设备ID") Integer devId) {
		log.info("mcp调用--->根据主机号和设备ID查询设备状态信息....ccuName:{},devId:{}",ccuName,devId);
		return deviceStatusUtil.findUserByUserId(CcuUtils.getCcuName(ccuName), devId);
	}
	@Tool(description = "智能家居相关：根据主机号同步设备")
	public boolean synchronousDevice(@ToolParam(description = "主机号")String ccuName){
		log.info("mcp调用--->根据主机号同步设备....ccuName:{}",ccuName);
		return sycDeviceService.synchronousDevice(CcuUtils.getCcuName(ccuName));
	}

	//==============================设备控制=============================================
	@Tool(description = "智能家居相关：根据主机号和设备ID控制:打开设备")
	public String optDeviceOpen(@ToolParam(description = "主机号")String ccuName,
	                            @ToolParam(description = "设备ID,多个使用逗号隔开")String devId){
		log.info("mcp调用--->根据主机号和多个设备ID与设备类型ID批量控制....ccuName:{},devIds:{}",ccuName,devId);
		return konkeIotServer.batchOptDeviceOpen(CcuUtils.getCcuName(ccuName), devId);
	}


	@Tool(description = "智能家居相关：根据主机号和设备ID控制:关闭设备")
	public String optDeviceClosed(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "设备ID,多个使用逗号隔开")String devId){
		log.info("mcp调用--->根据主机号和设备ID控制关闭设备..批量控制..ccuName:{},devId:{},",ccuName,devId);
		return konkeIotServer.batchOptDeviceClosed(CcuUtils.getCcuName(ccuName), devId);
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置亮度")
	public String setBrightness(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                            @ToolParam(description = "设置的亮度百分比大小,范围是0-100")int brightness){
		log.info("mcp调用--->根据主机号和设备ID控制设备亮度..批量控制..ccuName:{},devId:{},brightness:{}",ccuName,devId,brightness);
		return konkeIotServer.batchSetBrightness(CcuUtils.getCcuName(ccuName), devId,brightness);
	}
	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置色温")
	public String setColourTemperature(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                                   @ToolParam(description = "设置的色温百分比大小,范围是0-100")int colourTemperature){
		log.info("mcp调用--->根据主机号和设备ID控制设备的色温..批量控制..ccuName:{},devId:{},colourTemperature:{}",ccuName,devId,colourTemperature);
		return konkeIotServer.batchSetColourTemperature(CcuUtils.getCcuName(ccuName), devId,colourTemperature);
	}
	@Tool(description = "智能家居相关：根据主机号和设备ID控制:设置显示的颜色")
	public String setColor(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                       @ToolParam(description = "要设置的颜色,支持的颜色：Red,Yellow,Blue,Green,White,Black,Cyan,Purple,Orange,Pink,Violet,Magenta,Indigo,SlateBlue,DarkBlue,SkyBlue,DarkCyan,Beige,Brown")String color){
		log.info("mcp调用--->根据主机号和设备ID控制设备的颜色..批量控制..ccuName:{},devId:{},color:{}",ccuName,devId,color);
		return konkeIotServer.batchSetColor(CcuUtils.getCcuName(ccuName), devId,color);
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID控制:暂停设备.只支持窗帘类型")
	public String setPause(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "设备ID,多个使用逗号隔开")String devId){
		log.info("mcp调用--->根据主机号和设备ID控制暂停设备..批量控制..ccuName:{},devId:{}",ccuName,devId);
		return konkeIotServer.batchSetPause(CcuUtils.getCcuName(ccuName), devId);
	}
	@Tool(description = "智能家居相关：根据主机号和设备ID控制设备:移动位置.只支持窗帘电机(CURTAIN_MOTOR)类型")
	public String setMove(@ToolParam(description = "主机号")String ccuName,
	                       @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                      @ToolParam(description = "移动的距离,范围是0-100")int progress){
		log.info("mcp调用--->根据主机号和设备ID控制其移动位置..批量控制..ccuName:{},devId:{},progress:{}",ccuName,devId,progress);
		return konkeIotServer.batchSetMove(CcuUtils.getCcuName(ccuName), devId,progress);
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID控制设备:延时关机.只支持新风、地暖、空调")
	public String setDelayedShutdown(@ToolParam(description = "主机号")String ccuName,
	                      @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                      @ToolParam(description = "多少分钟后关机,范围30-1440,必须是30的倍数,最小是半小时")int delayTime){
		log.info("mcp调用--->根据主机号和设备ID控制设备延时关机..批量控制..ccuName:{},devId:{},delayTime:{}",ccuName,devId,delayTime);
		return konkeIotServer.batchSetDelayedShutdown(CcuUtils.getCcuName(ccuName), devId,delayTime);
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作温度.只支持空调、地暖")
	public String setTemperature(@ToolParam(description = "主机号")String ccuName,
	                                 @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                                 @ToolParam(description = "设置的温度大小,范围是5-35")double temperature){
		log.info("mcp调用--->根据主机号和设备ID设置设备的工作温度..批量控制..ccuName:{},devId:{},temperature:{}",ccuName,devId,temperature);
		return konkeIotServer.batchSetTemperature(CcuUtils.getCcuName(ccuName), devId,temperature);
	}
	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作模式.只支持地暖、空调、新风")
	public String setModel(@ToolParam(description = "主机号")String ccuName,
	                             @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                             @ToolParam(description = "设置的工作模式,枚举值:WIND、HOT、COLD、DEHUMIDIFICATION、AUTO、MANUAL")String mode){
		log.info("mcp调用--->根据主机号和设备ID设置设备的工作模式..批量控制..ccuName:{},devId:{},mode:{}",ccuName,devId,mode);
		return konkeIotServer.batchSetModel(CcuUtils.getCcuName(ccuName), devId,mode);
	}

	@Tool(description = "智能家居相关：根据主机号和设备ID设置设备的工作风速.只支持空调、新风")
	public String setSpeed(@ToolParam(description = "主机号")String ccuName,
	                       @ToolParam(description = "设备ID,多个使用逗号隔开")String devId,
	                       @ToolParam(description = "设置的工作风速,枚举值:LOW、MID、HIGH、AUTO、STOP")String speed){
		log.info("mcp调用--->根据主机号和设备ID设置设备的工作风速..批量控制..ccuName:{},devId:{},mode:{}",ccuName,devId,speed);
		return konkeIotServer.batchSetSpeed(CcuUtils.getCcuName(ccuName), devId,speed);
	}



	@Tool(description = "智能家居相关：根据主机号和场景ID:触发场景")
	public String triggerScene(@ToolParam(description = "主机号")String ccuName,
	                              @ToolParam(description = "场景ID")String devId,
	                              @ToolParam(description = "场景类型ID,type等于scene")String typeId){
		log.info("mcp调用--->根据主机号和场景ID触发场景....ccuName:{},devId:{},type:{}",ccuName,devId,typeId);
		return konkeIotServer.optScene(CcuUtils.getCcuName(ccuName), devId);
	}

	//===================================================================================================


}
