package com.ikonke.konkeaialibabamcp.aitools;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.service.cdc.spaces.SpacesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class CDCSpacesTools {

	private final SpacesService spacesService;

	public CDCSpacesTools(SpacesService spacesService) {
		this.spacesService = spacesService;
	}

	@Tool(description = "根据房间ID和日期查询该日期可预约情况")
	public JSONObject getAppointmentTimeByRoomId(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                             @ToolParam(description = "查询的日志，如：2025-08-12")String date,
	                                             @ToolParam(description = "查询的房间ID")String roomId,
	                                             @ToolParam(description = "查询的房间的子空间ID,可省略")String subspaceId){
		log.info("getAppointmentTimeByRoomId..获取预约时间..sn:{},time:{},roomId:{},roomSubspaceId:{}",sn,date,roomId,subspaceId);
		return spacesService.getAppointmentTimeByRoomId(sn,date,roomId,subspaceId);
	}

	@Tool(description = "获取该房间ID下可使用的优惠卷")
	public JSONArray getUserCoupons(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                @ToolParam(description = "查询的房间ID")String roomId){
		log.info("getUserCoupons..获取用户优惠券..sn:{},roomId:{}",sn,roomId);
		return spacesService.getUserCoupons(sn,roomId);
	}

	@Tool(description = "使用优惠卷预订房间")
	public boolean bookingOrder(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                            @ToolParam(description = "使用的开始时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 09:00:00")String beginTime,
	                            @ToolParam(description = "使用的结束时间,必须是30分钟的倍数且不能隔天预约,如：2025-08-12 10:30:00")String endTime,
	                            @ToolParam(description = "预约的房间ID")String roomId,
	                            @ToolParam(description = "预约的房间下的子空间ID")String subspaceId,
	                            @ToolParam(description = "使用的人数,必须大于1")int userQuantity,
	                            @ToolParam(description = "使用的优惠券ID,不能为空")String couponId){
		log.info("bookingOrder..预约订单..sn:{},beginTime:{},endTime:{},roomId:{},roomSubspaceId:{},userQuantity:{},couponId:{}",
				sn,beginTime,endTime,roomId,subspaceId,userQuantity,couponId);
		return spacesService.bookingOrder(sn,beginTime,endTime,roomId,subspaceId,userQuantity,couponId);
	}
}
