## 工具列表

> Http Streamable 模式访问：[https://mcp.cndmega.com/mcp](https://mcp.cndmega.com/mcp)

| 更新日期   | 变更内容                 |
| ---------- | ------------------------ |
| 2025-09-30 | 文档初始化               |
| 2025-10-14 | 接口相关参数调整         |
| 2025-11-03 | 调整访客预约新增车行预约 |
| 2025-11-04 | 新增紧急呼救工具         |

### 请求头参数

- Authorization(必需)

- user-token(必需)

- communityCode(必需)

- communityId(必需)

- easId(必需)

- roomId(必需)

- roomName(必需)

- buildingId(必需)

- userPhone(必需)

- userName(必需)

  >示例：
  >
  >{
  >
  >​	"Authorization": "Bearer 秘钥"
  >
  >​	"user-token": "eyJhbGciOiJIUzUxMiJ9.eyJ1c2VyX2lkIjoiMDA3NjdkOTAzZDU0NDY1YmE4YjdjMjY3MTMzZmFkZTAiLCJ1c2VyX2tleSI6IjVkNjljZjZlLWNlYmMtNGMwYy1hMmI2LTYwMTYyNWY1MWQ0NyIsInVzZXJuYW1lIjoiSXgrNk5RUno1ZE1vNnFqMndrN2twQT09In0.OH_wbW7ZxHcpeZ3x2kgp0SZXijW875cGcj0w1cg9GoJ7bm5GXg_FjIpvR1sLr5vbRKRoWjeS8O9vey_kD84uRg",
  >
  >​	"communityCode": "35020101",
  >
  >​	"easId": "NECtdFFjRuW32yezGyi0kpA%2BAjY%3D",
  >
  >​	"roomId": "21998",
  >
  >​	"roomName": "公寓B-2301",
  >
  >​	"buildingId": "9DAC3011-3844-4A25-B342-B023D2469657",
  >
  >​	"userPhone": "13599533372",
  >
  >​	"userName": "123123123"
  >
  >}

### 时间参数定义

- 只需精确到天的参数命名以 `date` 开头，格式为 `YYYY-MM-DD`，同时可支持相对时间格式：`now`, `-7d`, `-1m`, `-1y`
  - 例如：`dateStart="-7d"`表示查询从7天前开始的记录
  - 例如：`dateStart="now"`或者`date="0d"`表示查询当天的记录
  - 例如：`dateStart="-1m"`表示查询从1个月前开始的记录
  - 例如：`dateStart="-1y"`表示查询从1年前开始的记录
  - 例如：`dateInvite="+1d"`表示邀请访客明天来访
- 需精确到小时/分钟/秒的参数命名以 `datetime` 开头，格式为 `YYYY-MM-DD HH:MM:SS`



### 访客管理工具

#### createVisitorInvitation
创建访客邀请，生成访客记录。

**参数：**

- `name` (必需): 访客姓名
- `phone` (必需): 访客手机号码
- `datetimeStart` (必需): 到访起始时间 (格式：参考时间参数定义)
- `datetimeEnd` (必需): 到访结束时间 (格式：参考时间参数定义)
- `plate` (必需): 访客车牌号（如果客人不开车，请填写'不开车'或者'无车'或者'不带车'）

**注意：** 社区代码、房间ID、房间名称、楼栋ID等通用参数将从请求头自动获取

#### getVisitorInvitationList
查看业主的访客记录列表。

**参数：**

- `dateStart` (可选): 查询起始时间，默认为-7d 7天前(格式：参考时间参数定义)

**注意：** 社区代码等通用参数将从请求头自动获取

### 智慧会所工具

#### getClubList
查看当前所有的智慧会所。

**注意：** 社区ID和房间ID等通用参数将从请求头自动获取

#### getClubDetail
查看指定智慧会所的信息，包含开放时间和地址。

**参数：**

- `clubName` (必需): 会所名称

**注意：** 社区ID和房间ID等通用参数将从请求头自动获取

#### createClubAppointment
预约智慧会所。

**参数：**
- `clubName` (必需): 会所名称
- `datetimeStart` (必需): 预约日期开始时间 (格式: yyyy-MM-dd HH:mm:ss)
- `datetimeEnd` (必需): 预约时段结束时间 (格式: yyyy-MM-dd HH:mm:ss)

**注意：** 社区ID和房间ID等通用参数将从请求头自动获取

#### getClubAppointmentList
获取智慧会所预约订单列表。

**参数：**

- `dateStart` (可选): 查询起始时间，默认为-7d 7天前(格式：参考时间参数定义)

**注意：** 社区ID和房间ID等通用参数将从请求头自动获取

#### getClubSchedule
查询会所可预定时间表。

**参数：**

- `clubName` (必需): 会所名称
- `date` (可选): 查询日期, 默认值为now (格式：参考时间参数定义)

**注意：** 社区ID和房间ID等通用参数将从请求头自动获取

### 垃圾代收工具

#### createRobotAppointment
创建垃圾代收订单。

**注意：** 楼栋ID和房间ID等通用参数将从请求头自动获取

#### getRobotAppointmentList
查询垃圾代收订单列表。

**参数：**

- `dateStart` (可选): 查询起始时间，默认为-7d 7天前(格式：参考时间参数定义)

**注意：** 社区ID等通用参数将从请求头自动获取

### 工单服务工具

#### createWorkOrder
创建工单。

**参数：**

- `description` (必需): 问题描述

**注意：** 社区ID等通用参数将从请求头自动获取，默认创建"问题整改"类型工单

#### getWorkOrderList
查询工单列表。

**参数：**

- `dateStart` (可选): 查询起始时间，默认为-7d 7天前(格式：参考时间参数定义)

**注意：** 社区ID等通用参数将从请求头自动获取

### 紧急呼救工具

#### helpMe

紧急呼救，推送业务微信公众号消息。

**注意：** 社区ID等通用参数将从请求头自动获取