package com.ikonke.konkeaialibabamcp.controller.param;

import lombok.Data;

@Data
public class ResultResp<T> {

    /**
     * response error code to client
     */
    private int code = 0;

    /**
     * response error message to client
     */
    private String info = "";

    /**
     * response data to client.
     */
    private T data = null;

    private String messageId;

    public ResultResp() {
        this(200, "SUCCESS");
    }

    public ResultResp(Integer code, String info) {
        setCode(code);
        setInfo(info);
    }

    public static ResultResp badRequest() {
        ResultResp resp = new ResultResp(400, "bad request.");
        return resp;
    }
    public static  ResultResp setBadDate(Object t){
        ResultResp resp = new ResultResp(400, "bad request.");
        resp.setData(t);
        return resp;
    }

    public static  ResultResp setDate(Object t){
        ResultResp resp = new ResultResp();
        resp.setCode(200);
        resp.setInfo("SUCCESS");
        resp.setData(t);

        return resp;
    }

}
