package com.ikonke.konkeaialibabamcp.controller;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.ikonke.konkeaialibabamcp.service.SycDeviceService;
import com.ikonke.konkeaialibabamcp.utils.CcuUtils;
import com.ikonke.konkeaialibabamcp.utils.KonkeIotUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;



@Slf4j
@RestController
@RequestMapping("/deviceController")
public class DeviceController {

	@Autowired
	private SycDeviceService sycDeviceService;
	@Autowired
	private KonkeIotUtils konkeIotServer;

	@GetMapping("/findSycDeviceByCcu")
	public JSONArray findSycDeviceByCcu(@RequestParam(name = "ccuName") String ccuName,
	                                    @RequestParam(name = "type", required = false) Integer type,
	                                    @RequestParam(name = "capabilities", required = false) Integer capabilities){
		log.info("findSycDeviceByCcu..根据主机号查询设备..ccuName:{},type:{},capabilities:{}",ccuName,type,capabilities);
		return sycDeviceService.findByCcu(ccuName,type,capabilities);
	}

	@GetMapping("/findDeviceByName")
	public JSONArray findDeviceByName(@RequestParam(name = "ccuName") String ccuName,
	                                  @RequestParam(name = "deviceName", required = false) String deviceName,
	                                  @RequestParam(name = "roomName", required = false) String roomName){
		log.info("findDeviceByName..根据主机号和设备名称模糊查询设备..ccuName:{},deviceName:{},roomName:{}",ccuName,deviceName,roomName);
		return sycDeviceService.findDeviceByName(ccuName,deviceName,roomName);
	}
	@PostMapping("/findDeviceByName")
	public JSONArray findDeviceByName(@RequestParam(name = "ccuName") String ccuName,
	                                  @RequestBody JSONArray param){
		log.info("findDeviceByName..根据主机号和设备名称模糊查询设备.2..ccuName:{},param:{}",ccuName,param);
		return sycDeviceService.findDeviceByName2(ccuName,param);
	}

	@GetMapping("/synchronousDevice")
	public Boolean synchronousDevice(@RequestParam(value = "ccuName") String ccuName) {
		log.info("synchronousDevice..同步设备..ccuName:{}",ccuName);
		return sycDeviceService.synchronousDevice(ccuName);
	}






	@PostMapping("/addScene")
	public String addScene(@RequestHeader("temporarySceneId") String temporarySceneId,
	                       @RequestHeader("sn") String sn,
							@RequestParam(value = "ccuName") String ccuName,
	                        @RequestBody JSONObject actions) {
		log.info("addScene..新增场景..ccuName:{},temporarySceneId:{},sn:{},actions:{}",ccuName,temporarySceneId,sn,actions);
		konkeIotServer.delScene(sn,ccuName,temporarySceneId);
		return konkeIotServer.addScene(sn,ccuName,actions);
	}

	@DeleteMapping("/delScene")
	public Boolean delScene(@RequestHeader("temporarySceneId") String temporarySceneId,
	                       @RequestHeader("sn") String sn,
	                       @RequestParam(value = "ccuName") String ccuName) {
		log.info("delScene..删除场景..ccuName:{},temporarySceneId:{},sn:{}",ccuName,temporarySceneId,sn);
		return konkeIotServer.delScene(sn,ccuName,temporarySceneId);
	}

	@GetMapping("/triggerScene")
	public String triggerScene(@RequestParam(value = "ccuName")String ccuName,
	                           @RequestParam(value = "sceneId")String sceneId){
		log.info("triggerScene--->根据主机号和场景ID触发场景....ccuName:{},sceneId:{}",ccuName,sceneId);
		return konkeIotServer.optScene(CcuUtils.getCcuName(ccuName), sceneId);
	}

	@PostMapping("/saveTemporaryScene")
	public String saveTemporaryScene(@RequestParam(value = "sn") String sn,
			@RequestParam(value = "ccuName") String ccuName,
	                        @RequestParam(value = "temporarySceneId") String temporarySceneId) {
		log.info("saveTemporaryScene..临时场景存储..ccuName:{},temporarySceneId:{},sn:{}",ccuName,temporarySceneId,sn);

		if(konkeIotServer.saveTemporaryScene(sn,ccuName, temporarySceneId)){
			sycDeviceService.synchronousDevice(ccuName);
			return "保存成功";
		}else{
			return "保存失败";
		}
	}

}
