package com.ikonke.konkeaialibabamcp.constant;

import java.util.List;
import java.util.Map;

public class DeviceConstant {

	public final static List<String> speed_15005 = List.of(
			"LOW", "MID", "HIGH", "AUTO"
	);
	public final static List<String> speed_12505 = List.of(
			"LOW", "MID", "HIGH", "STOP"
	);
	public final static List<String> mode_15005 = List.of(
			"WIND", "HOT", "COLD", "DEHUMIDIFICATION"
	);
	public final static List<String> mode_12505 = List.of(
			"AUTO", "MANUAL"
	);

	/**
	 * 设备类型 -- OID
	 */
	public final static Map<String, List<Integer>> device_model = Map.of(
			"LIGHT", List.of(1,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,20,
					201,492,493,501,502,503,504,505,506,507,508,509,510,511,513,514,515,516,517,518,519),
//			"DIMMING_LIGHT",List.of(),
//			"SWITCH",List.of(),//
			"SOCKET",List.of(2006),//插座
			"CURTAIN", List.of(1008),//窗帘
			"CURTAIN_MOTOR",List.of(1003,1012,1016,1017),//窗帘电机
			"AIR_CONDITION",List.of(15005),//空调
			"FLOOR_HEATER",List.of(12505),//地暖
			"AIR_FRESHER",List.of(14003)//新风
//			"TV_SET",List.of(),
//			"AIR_PURIFIER",List.of(),
//			"FAN",List.of(),
//			"WATER_HEATER",List.of(),
//			"HEATER",List.of(),
//			"WASHING_MACHINE",List.of(),
//			"GAS_STOVE",List.of(),
//			"RANGE_HOOD",List.of(),
//			"OVEN",List.of(),
//			"MICROWAVE_OVEN",List.of(),
//			"PRESSURE_COOKER",List.of(),
//			"RICE_COOKER",List.of(),
//			"INDUCTION_COOKER",List.of(),
//			"HIGH_SPEED_BLENDER",List.of(),
//			"SWEEPING_ROBOT",List.of(),
//			"FRIDGE",List.of(),
//			"HUMIDIFIER",List.of(),
	);

	public static String getDeviceType(Integer devId) {
		for (Map.Entry<String, List<Integer>> entry : device_model.entrySet()) {
			if (entry.getValue().contains(devId)) {
				return entry.getKey();
			}
		}
		return "UNKNOWN";
	}
}
