package com.ikonke.konkeaialibabamcp.aitools;

import com.ikonke.konkeaialibabamcp.service.cdc.robot.CommunityRobot;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;


/**
 * 机器人相关
 */
@Slf4j
@Service
public class CDCRobotTools {

	private final CommunityRobot robot;

	public CDCRobotTools(CommunityRobot robot) {
		this.robot = robot;
	}

	/**
	 * 预约垃圾机器人
	 *
	 */
	@Tool(description = "社区机器人相关：预约垃圾回收机器人：垃圾回收机器人上门回收垃圾")
	public String bookingLitterRobot(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                 @ToolParam(description = "预约的时间(不能小于当前的日期),如：2025-08-12 13:20:00")String date){
		log.info("【{}】mcp调用--->预约垃圾机器人：垃圾代收下单:时间：{}",sn,date);
		return robot.bookingLitterRobot(sn, date);
	}


	/**
	 * 预约配送机器人
	 */
	@Tool(description = "社区机器人相关：预约配送机器人：配送机器人上门取件配送")
	public String bookingDeliveryRobot(@ToolParam(description = "设备的sn号,如：00226DA86A12")String sn,
	                                   @ToolParam(description = "预约的时间(不能小于当前的日期),如：2025-08-12 13:22:00")String date){
		log.info("mcp调用--->预约配送机器人：机器人配送下单:sn:{},时间：{}",sn,date);
		return robot.bookingDeliveryRobot(sn,date);
	}
}
