package com.ikonke.konkeaialibabamcp.utils;

import cn.hutool.http.HttpRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class WeatherUtils {
	@Value("${konke.weather.clientId}")
	private String clientId;

	private final static String weatherNowUrl = "https://kapp.ikonke.com/weather/v1/now?location=";
	private final static String weatherHourlyUrl = "https://kapp.ikonke.com/weather/v1/hourly?location=";
	private final static String weatherDailyUrl = "https://kapp.ikonke.com/weather/v1/daily?location=";


	public String getWeatherNow(String city) {
		String url =  weatherNowUrl + city;
		return HttpRequest.get(url)
				.header("clientId", clientId)
				.execute().body();
	}

	public String getWeatherHourly(String city) {
		String url =  weatherHourlyUrl + city;
		return HttpRequest.get(url)
				.header("clientId", clientId)
				.execute().body();
	}

	public String getWeatherDaily(String city) {
		String url =  weatherDailyUrl + city;
		return HttpRequest.get(url)
				.header("clientId", clientId)
				.execute().body();
	}



}
