package com.ikonke.konkeaialibabamcp.utils;

import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 *
 */
@Component
public class RedisCacheUtil {

	private final RedisTemplate<String, Object> redisTemplate;

	public RedisCacheUtil(RedisTemplate<String, Object> redisTemplate) {
		this.redisTemplate = redisTemplate;
	}

	public void set(String key, Object value, long timeout, TimeUnit unit) {
		redisTemplate.opsForValue().set(key, value, timeout, unit);
	}

	public Object get(String key) {
		return redisTemplate.opsForValue().get(key);
	}
}
