package com.ikonke.konkeaialibabamcp.mapper.mysql;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ikonke.konkeaialibabamcp.entity.mysql.CDCToken;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface CDCTokenMapper extends BaseMapper<CDCToken> {

	@Select("SELECT * FROM cdc_token WHERE sn = #{sn}")
	CDCToken findBySn(@Param("sn") String sn);

	@Select("SELECT * FROM cdc_token WHERE sn = #{sn} and `state` = #{state}")
	CDCToken findBySnAndState(@Param("sn") String sn, @Param("state") Integer state);

	@Update("UPDATE cdc_token SET accessToken = NULL WHERE DATE(createTime) < DATE_SUB(CURDATE(), INTERVAL #{num} DAY);")
	int examineCDCToken(@Param("num") int num);
}
