#ifndef __MAIN_H__
#define __MAIN_H__

#define OLED_LOG(level, fmt, args...)   \
    do                                  \
    {                                   \
        syslog(level, fmt, ##args);     \
        printf("\n["__FILE__":%d] "fmt,__LINE__, ##args); \
    } while(0)

#define OLED_LOG_DBG(fmt, args...)      OLED_LOG(LOG_DEBUG, fmt, ##args)


#define ETH0_MAC_NAME             "eth0"
#define ETH1_MAC_NAME             "eth1"


#define MAC_SIZE    18
#define IP_SIZE     16

#define IN_PORT     13000
#define SERV_PORT 27001

#define  VERSION_CFG_FILE  "/etc/ver/online"

#define  SN_CFG_FILE  "/etc/ver/sn_cfg"

#define CCUID_CFG_FILE  "/etc/dropbear/accessory/hj/hj_ccuid"

#define ETH1_ADDRESS_FILE_PATH  "/sys/class/net/eth1/address"

#define ETH0_ADDRESS_FILE_PATH  "/sys/class/net/eth0/address"

#define RUN_FLAG_WIFI_SUB_BOARD  "subboard"  // wifi
#define RUN_FLAG_AGING  "aging"  // ϻ
#define RUN_FLAG_TEST  "test"  // 
#define RUN_FLAG_OK  "success"  // Գɹ


#define SET_SN_CMD "/usr/sbin/fw_setenv sn "
#define GET_SN_CMD "/usr/sbin/fw_printenv sn -n"

typedef struct
{
    char ccu_id[16];
    char ccu_name[32];
    char ccu_version[32];
    char version_str[64];
    char ccu_lan[16];

    int ccu_show_qr;
    char ccu_qr_str[128];

    int ccu_status;
    char ccu_udp_path[128];

    int hw_version;
} oled_config_t;

extern char run_flag[10];

extern char run_flag_file_name[30];


extern oled_config_t g_oled_config;

uint8_t get_mac(char *mac_name, char *mac_str, int len);
void save_cfg_str_to_file(const char *cfg_file_name, char *str);
void load_sn_from_file(char *cfg_file_name, char *str);

#endif /* __MAIN_H__ */


