#ifndef _KK_VOICE_PANEL_HANDLE_H
#define _KK_VOICE_PANEL_HANDLE_H

#include "uart_proto.h"
#include "kk_lan_voice_panel.h"
#include "kk_voice_panel_cfg.h"

#define VP_VP_CONFIG_FILE_DIR			"/etc/smarthome"
#define VP_CONFIG_FILE					"/etc/smarthome/voice_data.json"
#define VP_CONFIG_FILE_MD5				"/data/kk/voice_data.MD5"
#define VP_CONFIG_FILE_TAR_GZ			"/data/kk/voice_data.tar.gz"
#define VP_OTA_FILE_BZIP				"/data/kk/kk_voice.bzip"
#define VP_SCENE_ID_FILE				"/data/kk/scene_id_map.json"



#define OPCODE_8009_SNAPSHOOT				0x1000
#define OPCODE_SNAPSHOOT					0x1001
#define OPCODE_SCENE_ID_NOTIFY				0x1003
#define OPCODE_SYSTEM_TIME_SET				0x1009
#define OPCODE_SYSTEM_TIME_GET				0x100A
#define OPCODE_ACTION_NOTIFY				0x100B
#define OPCODE_CONFIG_FILE_UPDATE_NOTIFY	0x100C
#define OPCODE_CONFIG_DATA_REQUEST			0x100D
#define OPCODE_CONFIG_FILE_UPDATE_STOP		0x100E
#define OPCODE_CONFIG_FILE_INFO_GET			0x100F
#define OPCODE_CONFIG_FILE_UPDATE_STATUS	0x1010
#define OPCODE_VOICE_CONTROL_NOTIFY			0x1022


#define OPCODE_VOICE_OTA_UPGRADE_STATR		0x1016
#define OPCODE_VOICE_OTA_REQUEST			0x1017
#define OPCODE_VOICE_OTA_UPGRADE_STOP		0x1018
#define OPCODE_VOICE_OTA_INFO_GET			0x1019
#define OPCODE_VOICE_OTA_STATUS_NOTIFY		0x101A





typedef void (*vp_handle_func)(pro_data_t *pro_data);
typedef struct 
{
	uint16_t opcode;
	vp_handle_func func;
}VP_OPCODE_HANDLE;



int vp_scene_id_map_load(void);

void vp_scene_id_map_deinit(void);
int vp_scene_id_item_add(int scene_id);


//主机快照请求
void vp_8009_snapshoot_get(void);
void kk_vp_set_8009_system_time(void);
void kk_vp_config_file_update_start(uint32_t ver);
void kk_vp_config_file_update_stop(uint32_t ver);
void kk_vp_get_config_file_info(void);




void kk_vp_get_ota_file_info(void);
void kk_vp_ota_file_update_start(uint32_t ver);
void kk_vp_ota_file_update_stop(uint32_t ver);







void kk_vp_get_8009_snapshoot(void);

void kk_vp_syncinfo_handle(_IN cJSON *payload);
int kk_vp_opcode_handle(_IN pro_data_t *pro_data);

int kk_vp_get_config_file_version(void);


void vp_scene_id_map_deinit(void);
int vp_scene_id_item_add(int scene_id);
int vp_scene_id_item_load(int scene_id,uint16_t map_id);
int vp_scene_id_map_save(void);




int _vp_get_cfg_file_crc32(void);
int _vp_get_cfg_file_size(void);



#endif


