#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "MQTTAsync.h"

static const char* OPT_SEND = "MQTTAsync_sendMessage";
static const char* OPT_SUB = "MQTTAsync_subscribe";
static const char* OPT_UNSUB = "MQTTAsync_unsubscribe";

static void onOptSuccess(void* context, MQTTAsync_successData* response)
{
	if(strcmp((char *)context,OPT_SEND)==0)
	{
		printf("MQTTAsync_sendMessage success,return token:%d,msg length:%d \n",
		     response->token,response->alt.pub.message.payloadlen);

	}
	else if(strcmp((char *)context,OPT_SUB)==0)
	{
		printf("MQTTAsync_subscribe success,return token:%d \n",response->token);
	}
	else if(strcmp((char *)context,OPT_UNSUB)==0)
	{
		printf("MQTTAsync_unsubscribe success,return token:%d \n",response->token);
	}
}
static void onOptFail(void* context,  MQTTAsync_failureData* response)
{
	if(strcmp((char *)context,OPT_SEND)==0)
	{
		printf("MQTTAsync_sendMessage fail,token:%d,code:%d,msg:%s \n",
		     response->token,response->code,response->message);
	}
	else if(strcmp((char *)context,OPT_SUB)==0)
	{
		printf("MQTTAsync_subscribe fail,return token:%d \n",response->token);
	}
	else if(strcmp((char *)context,OPT_UNSUB)==0)
	{
		printf("MQTTAsync_unsubscribe fail,return token:%d \n",response->token);
	}
}

int KK_MQTT_SubTopic(MQTTAsync handle,char *topicName,int qos,int waitTimeout)
{
	printf("to subtopic:%s \n",topicName);

	MQTTAsync_responseOptions opts = MQTTAsync_responseOptions_initializer;
	int rc;

	opts.onSuccess = onOptSuccess;
	opts.onFailure = onOptFail;
	opts.context = (void*)OPT_SUB;

	if ((rc = MQTTAsync_subscribe(handle,topicName, qos, &opts)) != MQTTASYNC_SUCCESS)
	{
		printf("Failed to start subscribe, return code:%d.\n", rc);
		return -1;
	}
	return 0;


}

int KK_MQTT_SendMsg(MQTTAsync handle,char *topicName,const char *payload,int qos)
{

	MQTTAsync_responseOptions opts = MQTTAsync_responseOptions_initializer;
	MQTTAsync_message pubmsg = MQTTAsync_message_initializer;
	int rc;

	opts.onSuccess = onOptSuccess;
	opts.onFailure = onOptFail;
	opts.context =  (void*)OPT_SEND;

	pubmsg.payload = (void*)payload;
	pubmsg.payloadlen = strlen(payload);
	pubmsg.qos = qos;
	pubmsg.retained = 0;

	printf("mqtt send payload len:%d,qos:%d.\n",pubmsg.payloadlen,qos);

	if ((rc = MQTTAsync_sendMessage(handle, topicName, &pubmsg, &opts)) != MQTTASYNC_SUCCESS){
		printf("Failed to start sendMessage, return code:%d.\n", rc);
		return -1;
	}
	return rc;
}
int KK_MQTT_RecvMsg(MQTTAsync handle,const char *topicName,const char *payload)
{
	if(topicName == NULL)
	{
		return -1;
	}
	return 0;
}

int KK_MQTT_UnsubTopic(MQTTAsync handle,const char *topicName)
{
	printf("to unsubtopic:%s \n",topicName);

	MQTTAsync_responseOptions opts = MQTTAsync_responseOptions_initializer;
	int rc;

	opts.onSuccess = onOptSuccess;
	opts.onFailure = onOptFail;
	opts.context = (void*)OPT_UNSUB;

	if ((rc = MQTTAsync_unsubscribe(handle,topicName,&opts)) != MQTTASYNC_SUCCESS){
		printf("Failed to start unubscribe, return code:%d.\n", rc);
		return -1;
	}
	return rc;
}



