#ifndef _KK_PROPERTY_DB_H_
#define _KK_PROPERTY_DB_H_
#include "kk_tsl_common.h"
#include "sqlite3.h"

enum{
	DB_LOCKKEY_IDX = 0,
	DB_LOCKKEY_DEVICECODE,
	DB_LOCKKEY_KEYID,
	DB_LOCKKEY_KEYTYPE,
	DB_LOCKKEY_KEYROLE,
	DB_LOCKKEY_ISVALID,
	DB_LOCKKEY_KEYNAME,
	DB_LOCKKEY_KEYEFFECTIVE,
	DB_LOCKKEY_KEYEXPIRE
};
typedef struct {
	void *mutex;
	sqlite3 *pDb;	
} kk_property_db_ctx_t;
typedef struct{
	int type;
	char deviceCode[DEVICE_CODE_MAXLEN];
	char raw[60];
}kk_prop_raw_struct_t;

enum{
	DB_IDX = 0,
	DB_DEVICECODE,
	DB_IDENTIFITER,
	DB_VALUE,
	DB_VALUETYPE,
	DB_DEVTYPE
};
enum{
	DB_INDOORAIR_IDX = 0,
	DB_INDOORAIR_DEVICECODE,
	DB_INDOORAIR_IDENTIFITER,
	DB_INDOORAIR_VALUE,
	DB_INDOORAIR_VALUETYPE,
	DB_INDOORAIR_EPNUM
};
int kk_property_db_init(void);
int kk_property_db_get_rawdata(const char *identifier,const int dev_type, kk_prop_raw_struct_t* raw, int count);
int kk_property_db_update_value(const char *deviceCode,const char *identifier,const char* value);
int kk_property_db_insert(const char *deviceCode,const char *identifier,kk_tsl_data_type_e valuetype,int devtype);
int kk_property_db_update_value(const char *deviceCode,const char *identifier,const char* value);
int kk_property_db_get_value_directly(const char *deviceCode,const char *identifier,char* value);
int kk_property_db_get_value(const char *deviceCode,const char *identifier,void* value);
int kk_property_db_update(const char *deviceCode);
int kk_property_sync_values(const char *deviceCode);
int kk_property_delete_by_dcode(char deviceCode[DEVICE_CODE_MAXLEN]);
int kk_property_update_lockkeys(char deviceCode[DEVICE_CODE_MAXLEN],char *keyId,int KeyType, int KeyRole, \
		int IsValid,char *KeyName,int KeyEffectiveTime,int KeyExpiryTime);
int kk_property_delete_lockkeys(char deviceCode[DEVICE_CODE_MAXLEN],char *keyId);
int kk_indoorAir_db_insert(const char *deviceCode,const char *identifier,kk_tsl_data_type_e valuetype,int epNum);
int kk_indoorAir_db_update_value(const char *deviceCode,const char *identifier,const char* value,int epNum);
int kk_indoorAir_query_epnums(const char *deviceCode,int epList[]);
#endif

